/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperationsAdapter;
import org.springframework.data.mongodb.repository.support.IndexEnsuringQueryCreationListener;
import org.springframework.data.mongodb.repository.support.ReactiveMongoRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveMongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private ReactiveMongoOperations operations;
    private boolean createIndexesForQueryMethods = false;
    private boolean mappingContextConfigured = false;

    public ReactiveMongoRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setReactiveMongoOperations(@Nullable ReactiveMongoOperations operations) {
        this.operations = operations;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.getFactoryInstance(this.operations);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener((QueryCreationListener)new IndexEnsuringQueryCreationListener(collectionName -> IndexOperationsAdapter.blocking(this.operations.indexOps(collectionName))));
        }
        return factory;
    }

    protected RepositoryFactorySupport getFactoryInstance(ReactiveMongoOperations operations) {
        return new ReactiveMongoRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.operations != null ? 1 : 0) != 0, (String)"ReactiveMongoOperations must not be null!");
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.operations.getConverter().getMappingContext());
        }
    }
}

