/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.lang.Nullable;

public interface MongoPersistentProperty
extends PersistentProperty<MongoPersistentProperty> {
    public String getFieldName();

    public Class<?> getFieldType();

    public int getFieldOrder();

    public boolean isDbReference();

    public boolean isExplicitIdProperty();

    public boolean isLanguageProperty();

    public boolean isExplicitLanguageProperty();

    public boolean isTextScoreProperty();

    @Nullable
    public DBRef getDBRef();

    public boolean usePropertyAccess();

    default public boolean hasExplicitWriteTarget() {
        Field field = (Field)this.findAnnotation(Field.class);
        return field != null ? !FieldType.IMPLICIT.equals((Object)field.targetType()) : false;
    }

    public static enum PropertyToFieldNameConverter implements Converter<MongoPersistentProperty, String>
    {
        INSTANCE;


        public String convert(MongoPersistentProperty source) {
            return source.getFieldName();
        }
    }
}

