/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoException;
import com.mongodb.TransactionOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.ReactiveMongoResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

public class ReactiveMongoTransactionManager
extends AbstractReactiveTransactionManager
implements InitializingBean {
    @Nullable
    private ReactiveMongoDatabaseFactory databaseFactory;
    @Nullable
    private TransactionOptions options;

    public ReactiveMongoTransactionManager() {
    }

    public ReactiveMongoTransactionManager(ReactiveMongoDatabaseFactory databaseFactory) {
        this(databaseFactory, null);
    }

    public ReactiveMongoTransactionManager(ReactiveMongoDatabaseFactory databaseFactory, @Nullable TransactionOptions options) {
        Assert.notNull((Object)databaseFactory, (String)"DatabaseFactory must not be null!");
        this.databaseFactory = databaseFactory;
        this.options = options;
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) throws TransactionException {
        ReactiveMongoResourceHolder resourceHolder = (ReactiveMongoResourceHolder)((Object)synchronizationManager.getResource((Object)this.getRequiredDatabaseFactory()));
        return new ReactiveMongoTransactionObject(resourceHolder);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return ReactiveMongoTransactionManager.extractMongoTransaction(transaction).hasResourceHolder();
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transaction, TransactionDefinition definition) throws TransactionException {
        return Mono.defer(() -> {
            ReactiveMongoTransactionObject mongoTransactionObject = ReactiveMongoTransactionManager.extractMongoTransaction(transaction);
            Mono<ReactiveMongoResourceHolder> holder = this.newResourceHolder(definition, ClientSessionOptions.builder().causallyConsistent(true).build());
            return holder.doOnNext(resourceHolder -> {
                mongoTransactionObject.setResourceHolder((ReactiveMongoResourceHolder)((Object)((Object)resourceHolder)));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("About to start transaction for session %s.", ReactiveMongoTransactionManager.debugString(resourceHolder.getSession())));
                }
            }).doOnNext(resourceHolder -> {
                mongoTransactionObject.startTransaction(this.options);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Started transaction for session %s.", ReactiveMongoTransactionManager.debugString(resourceHolder.getSession())));
                }
            }).onErrorMap(ex -> new TransactionSystemException(String.format("Could not start Mongo transaction for session %s.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())), ex)).doOnSuccess(resourceHolder -> synchronizationManager.bindResource((Object)this.getRequiredDatabaseFactory(), (Object)resourceHolder)).then();
        });
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) throws TransactionException {
        return Mono.fromSupplier(() -> {
            ReactiveMongoTransactionObject mongoTransactionObject = ReactiveMongoTransactionManager.extractMongoTransaction(transaction);
            mongoTransactionObject.setResourceHolder(null);
            return synchronizationManager.unbindResource((Object)this.getRequiredDatabaseFactory());
        });
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, @Nullable Object transaction, Object suspendedResources) {
        return Mono.fromRunnable(() -> synchronizationManager.bindResource((Object)this.getRequiredDatabaseFactory(), suspendedResources));
    }

    protected final Mono<Void> doCommit(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        return Mono.defer(() -> {
            ReactiveMongoTransactionObject mongoTransactionObject = ReactiveMongoTransactionManager.extractMongoTransaction(status);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("About to commit transaction for session %s.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())));
            }
            return this.doCommit(synchronizationManager, mongoTransactionObject).onErrorMap(ex -> new TransactionSystemException(String.format("Could not commit Mongo transaction for session %s.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())), ex));
        });
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager synchronizationManager, ReactiveMongoTransactionObject transactionObject) {
        return transactionObject.commitTransaction();
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) {
        return Mono.defer(() -> {
            ReactiveMongoTransactionObject mongoTransactionObject = ReactiveMongoTransactionManager.extractMongoTransaction(status);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("About to abort transaction for session %s.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())));
            }
            return mongoTransactionObject.abortTransaction().onErrorResume(MongoException.class, ex -> Mono.error((Throwable)new TransactionSystemException(String.format("Could not abort Mongo transaction for session %s.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())), (Throwable)ex)));
        });
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        return Mono.fromRunnable(() -> {
            ReactiveMongoTransactionObject transactionObject = ReactiveMongoTransactionManager.extractMongoTransaction(status);
            transactionObject.getRequiredResourceHolder().setRollbackOnly();
        });
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        Assert.isInstanceOf(ReactiveMongoTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveMongoTransactionObject.class, transaction.getClass()));
        return Mono.fromRunnable(() -> {
            ReactiveMongoTransactionObject mongoTransactionObject = (ReactiveMongoTransactionObject)transaction;
            synchronizationManager.unbindResource((Object)this.getRequiredDatabaseFactory());
            mongoTransactionObject.getRequiredResourceHolder().clear();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("About to release Session %s after transaction.", ReactiveMongoTransactionManager.debugString(mongoTransactionObject.getSession())));
            }
            mongoTransactionObject.closeSession();
        });
    }

    public void setDatabaseFactory(ReactiveMongoDatabaseFactory databaseFactory) {
        Assert.notNull((Object)databaseFactory, (String)"DatabaseFactory must not be null!");
        this.databaseFactory = databaseFactory;
    }

    public void setOptions(@Nullable TransactionOptions options) {
        this.options = options;
    }

    @Nullable
    public ReactiveMongoDatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public void afterPropertiesSet() {
        this.getRequiredDatabaseFactory();
    }

    private Mono<ReactiveMongoResourceHolder> newResourceHolder(TransactionDefinition definition, ClientSessionOptions options) {
        ReactiveMongoDatabaseFactory dbFactory = this.getRequiredDatabaseFactory();
        return dbFactory.getSession(options).map(session -> new ReactiveMongoResourceHolder((ClientSession)session, dbFactory));
    }

    private ReactiveMongoDatabaseFactory getRequiredDatabaseFactory() {
        Assert.state((this.databaseFactory != null ? 1 : 0) != 0, (String)"ReactiveMongoTransactionManager operates upon a ReactiveMongoDatabaseFactory. Did you forget to provide one? It's required.");
        return this.databaseFactory;
    }

    private static ReactiveMongoTransactionObject extractMongoTransaction(Object transaction) {
        Assert.isInstanceOf(ReactiveMongoTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveMongoTransactionObject.class, transaction.getClass()));
        return (ReactiveMongoTransactionObject)transaction;
    }

    private static ReactiveMongoTransactionObject extractMongoTransaction(GenericReactiveTransaction status) {
        Assert.isInstanceOf(ReactiveMongoTransactionObject.class, (Object)status.getTransaction(), () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveMongoTransactionObject.class, status.getTransaction().getClass()));
        return (ReactiveMongoTransactionObject)status.getTransaction();
    }

    private static String debugString(@Nullable ClientSession session) {
        if (session == null) {
            return "null";
        }
        String debugString = String.format("[%s@%s ", ClassUtils.getShortName(session.getClass()), Integer.toHexString(session.hashCode()));
        try {
            if (session.getServerSession() != null) {
                debugString = debugString + String.format("id = %s, ", session.getServerSession().getIdentifier());
                debugString = debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = debugString + String.format("txNumber = %d, ", session.getServerSession().getTransactionNumber());
                debugString = debugString + String.format("closed = %d, ", session.getServerSession().isClosed());
                debugString = debugString + String.format("clusterTime = %s", session.getClusterTime());
            } else {
                debugString = debugString + "id = n/a";
                debugString = debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = debugString + String.format("clusterTime = %s", session.getClusterTime());
            }
        }
        catch (RuntimeException e) {
            debugString = debugString + String.format("error = %s", e.getMessage());
        }
        debugString = debugString + "]";
        return debugString;
    }

    protected static class ReactiveMongoTransactionObject
    implements SmartTransactionObject {
        @Nullable
        private ReactiveMongoResourceHolder resourceHolder;

        ReactiveMongoTransactionObject(@Nullable ReactiveMongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        void setResourceHolder(@Nullable ReactiveMongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        final boolean hasResourceHolder() {
            return this.resourceHolder != null;
        }

        void startTransaction(@Nullable TransactionOptions options) {
            ClientSession session = this.getRequiredSession();
            if (options != null) {
                session.startTransaction(options);
            } else {
                session.startTransaction();
            }
        }

        public Mono<Void> commitTransaction() {
            return Mono.from((Publisher)this.getRequiredSession().commitTransaction());
        }

        public Mono<Void> abortTransaction() {
            return Mono.from((Publisher)this.getRequiredSession().abortTransaction());
        }

        void closeSession() {
            ClientSession session = this.getRequiredSession();
            if (session.getServerSession() != null && !session.getServerSession().isClosed()) {
                session.close();
            }
        }

        @Nullable
        public ClientSession getSession() {
            return this.resourceHolder != null ? this.resourceHolder.getSession() : null;
        }

        private ReactiveMongoResourceHolder getRequiredResourceHolder() {
            Assert.state((this.resourceHolder != null ? 1 : 0) != 0, (String)"ReactiveMongoResourceHolder is required but not present. o_O");
            return this.resourceHolder;
        }

        private ClientSession getRequiredSession() {
            ClientSession session = this.getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"A Session is required but it turned out to be null.");
            return session;
        }

        public boolean isRollbackOnly() {
            return this.resourceHolder != null && this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
            throw new UnsupportedOperationException("flush() not supported");
        }
    }
}

