/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import java.util.Collection;
import org.springframework.data.redis.core.index.IndexValueTransformer;
import org.springframework.data.util.TypeInformation;

public interface IndexDefinition {
    public String getKeyspace();

    public Collection<Condition<?>> getConditions();

    public IndexValueTransformer valueTransformer();

    public String getIndexName();

    public static final class IndexingContext {
        private final String keyspace;
        private final String path;
        private final TypeInformation<?> typeInformation;

        public IndexingContext(String keyspace, String path, TypeInformation<?> typeInformation) {
            this.keyspace = keyspace;
            this.path = path;
            this.typeInformation = typeInformation;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getPath() {
            return this.path;
        }

        public TypeInformation<?> getTypeInformation() {
            return this.typeInformation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexingContext)) {
                return false;
            }
            IndexingContext other = (IndexingContext)o;
            String this$keyspace = this.getKeyspace();
            String other$keyspace = other.getKeyspace();
            if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            TypeInformation<?> this$typeInformation = this.getTypeInformation();
            TypeInformation<?> other$typeInformation = other.getTypeInformation();
            return !(this$typeInformation == null ? other$typeInformation != null : !this$typeInformation.equals(other$typeInformation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $keyspace = this.getKeyspace();
            result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            TypeInformation<?> $typeInformation = this.getTypeInformation();
            result = result * 59 + ($typeInformation == null ? 43 : $typeInformation.hashCode());
            return result;
        }

        public String toString() {
            return "IndexDefinition.IndexingContext(keyspace=" + this.getKeyspace() + ", path=" + this.getPath() + ", typeInformation=" + this.getTypeInformation() + ")";
        }
    }

    public static interface Condition<T> {
        public boolean matches(T var1, IndexingContext var2);
    }
}

