/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.NamedNode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisNode
implements NamedNode {
    @Nullable
    String id;
    @Nullable
    String name;
    @Nullable
    String host;
    int port;
    @Nullable
    NodeType type;
    @Nullable
    String masterId;

    public RedisNode(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null!");
        this.host = host;
        this.port = port;
    }

    protected RedisNode() {
    }

    private RedisNode(RedisNode redisNode) {
        this.id = redisNode.id;
        this.name = redisNode.name;
        this.host = redisNode.host;
        this.port = redisNode.port;
        this.type = redisNode.type;
        this.masterId = redisNode.masterId;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public boolean hasValidHost() {
        return StringUtils.hasText((String)this.host);
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public String asString() {
        return this.host + ":" + this.port;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getMasterId() {
        return this.masterId;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    public NodeType getType() {
        return this.type;
    }

    public boolean isMaster() {
        return ObjectUtils.nullSafeEquals((Object)((Object)NodeType.MASTER), (Object)((Object)this.getType()));
    }

    public boolean isSlave() {
        return this.isReplica();
    }

    public boolean isReplica() {
        return ObjectUtils.nullSafeEquals((Object)((Object)NodeType.SLAVE), (Object)((Object)this.getType()));
    }

    public static RedisNodeBuilder newRedisNode() {
        return new RedisNodeBuilder();
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.host);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.port);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RedisNode)) {
            return false;
        }
        RedisNode other = (RedisNode)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.host, (Object)other.host)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.port, (Object)other.port)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
    }

    public static class RedisNodeBuilder {
        private RedisNode node = new RedisNode();

        public RedisNodeBuilder withName(String name) {
            this.node.name = name;
            return this;
        }

        public RedisNodeBuilder listeningAt(String host, int port) {
            Assert.notNull((Object)host, (String)"Hostname must not be null.");
            this.node.host = host;
            this.node.port = port;
            return this;
        }

        public RedisNodeBuilder withId(String id) {
            this.node.id = id;
            return this;
        }

        public RedisNodeBuilder promotedAs(NodeType type) {
            this.node.type = type;
            return this;
        }

        public RedisNodeBuilder slaveOf(String masterId) {
            return this.replicaOf(masterId);
        }

        public RedisNodeBuilder replicaOf(String masterId) {
            this.node.masterId = masterId;
            return this;
        }

        public RedisNode build() {
            return new RedisNode(this.node);
        }
    }

    public static enum NodeType {
        MASTER,
        SLAVE;

    }
}

