/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@NullUnmarked
public interface RedisKeyCommands {
    public Boolean copy(byte @NonNull [] var1, byte @NonNull [] var2, boolean var3);

    default public Boolean exists(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Long count = this.exists(new byte[][]{key});
        return count != null ? Boolean.valueOf(count > 0L) : null;
    }

    public Long exists(byte[] ... var1);

    public Long del(byte[] ... var1);

    public Long unlink(byte[] ... var1);

    public DataType type(byte @NonNull [] var1);

    public Long touch(byte[] ... var1);

    public Set<byte @NonNull []> keys(byte @NonNull [] var1);

    default public Cursor<byte @NonNull []> scan(@NonNull KeyScanOptions options) {
        return this.scan((ScanOptions)options);
    }

    public Cursor<byte @NonNull []> scan(@Nullable ScanOptions var1);

    public byte[] randomKey();

    public void rename(byte @NonNull [] var1, byte @NonNull [] var2);

    public Boolean renameNX(byte @NonNull [] var1, byte @NonNull [] var2);

    default public Boolean applyExpiration(byte @NonNull [] key, @NonNull Expiration expiration, @NonNull ExpirationOptions options) {
        if (expiration.isPersistent()) {
            return this.persist(key);
        }
        if (ObjectUtils.nullSafeEquals((Object)ExpirationOptions.none(), (Object)options)) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                if (expiration.isUnixTimestamp()) {
                    return this.expireAt(key, expiration.getExpirationTimeInMilliseconds());
                }
                return this.expire(key, expiration.getExpirationTimeInMilliseconds());
            }
            if (expiration.isUnixTimestamp()) {
                return this.expireAt(key, expiration.getExpirationTimeInSeconds());
            }
            return this.expire(key, expiration.getExpirationTimeInSeconds());
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
            if (expiration.isUnixTimestamp()) {
                return this.expireAt(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition());
            }
            return this.expire(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition());
        }
        if (expiration.isUnixTimestamp()) {
            return this.expireAt(key, expiration.getExpirationTimeInSeconds(), options.getCondition());
        }
        return this.expire(key, expiration.getExpirationTimeInSeconds(), options.getCondition());
    }

    default public Boolean expire(byte @NonNull [] key, long seconds) {
        return this.expire(key, seconds, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expire(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean expire(byte @NonNull [] key, @NonNull Duration duration) {
        return this.expire(key, duration.toSeconds());
    }

    default public Boolean pExpire(byte @NonNull [] key, long millis) {
        return this.pExpire(key, millis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpire(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean pExpire(byte @NonNull [] key, @NonNull Duration duration) {
        return this.pExpire(key, duration.toMillis());
    }

    default public Boolean expireAt(byte @NonNull [] key, long unixTime) {
        return this.expireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expireAt(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean expireAt(byte @NonNull [] key, @NonNull Instant unixTime) {
        return this.expireAt(key, unixTime.getEpochSecond());
    }

    default public Boolean pExpireAt(byte @NonNull [] key, long unixTimeInMillis) {
        return this.pExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpireAt(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4);

    default public Boolean pExpireAt(byte @NonNull [] key, @NonNull Instant unixTime) {
        return this.pExpireAt(key, unixTime.toEpochMilli());
    }

    public Boolean persist(byte @NonNull [] var1);

    public Boolean move(byte @NonNull [] var1, int var2);

    public Long ttl(byte @NonNull [] var1);

    public Long ttl(byte @NonNull [] var1, @NonNull TimeUnit var2);

    public Long pTtl(byte @NonNull [] var1);

    public Long pTtl(byte @NonNull [] var1, @NonNull TimeUnit var2);

    public List<byte @NonNull []> sort(byte @NonNull [] var1, @Nullable SortParameters var2);

    public Long sort(byte @NonNull [] var1, @Nullable SortParameters var2, byte @NonNull [] var3);

    public byte[] dump(byte @NonNull [] var1);

    default public void restore(byte @NonNull [] key, long ttlInMillis, byte @NonNull [] serializedValue) {
        this.restore(key, ttlInMillis, serializedValue, false);
    }

    public void restore(byte @NonNull [] var1, long var2, byte @NonNull [] var4, boolean var5);

    public ValueEncoding encodingOf(byte @NonNull [] var1);

    public Duration idletime(byte @NonNull [] var1);

    public Long refcount(byte @NonNull [] var1);
}

