/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.async.RedisHLLAsyncCommands;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceHyperLogLogCommands
implements RedisHyperLogLogCommands {
    private final LettuceConnection connection;

    LettuceHyperLogLogCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long pfAdd(byte @NonNull [] key, byte[] ... values) {
        Assert.notEmpty((Object[])values, (String)"PFADD requires at least one non 'null' value.");
        Assert.noNullElements((Object[])values, (String)"Values for PFADD must not contain 'null'");
        return (Long)this.connection.invoke().just(RedisHLLAsyncCommands::pfadd, key, values);
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFCOUNT must not contain 'null'");
        return (Long)this.connection.invoke().just(RedisHLLAsyncCommands::pfcount, keys);
    }

    @Override
    public void pfMerge(byte @NonNull [] destinationKey, byte[] ... sourceKeys) {
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sourceKeys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])sourceKeys, (String)"Keys for PFMERGE must not contain 'null'");
        this.connection.invoke().just(RedisHLLAsyncCommands::pfmerge, destinationKey, sourceKeys);
    }
}

