/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SelectList;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class SelectListVisitor
extends TypedSubtreeVisitor<SelectList>
implements PartRenderer {
    private final RenderContext context;
    private final StringBuilder builder = new StringBuilder();
    private final RenderTarget target;
    private boolean requiresComma = false;
    private boolean insideFunction = false;

    SelectListVisitor(RenderContext context, RenderTarget target) {
        this.context = context;
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (this.requiresComma) {
            this.builder.append(", ");
            this.requiresComma = false;
        }
        if (segment instanceof SimpleFunction) {
            this.builder.append(((SimpleFunction)segment).getFunctionName()).append("(");
            this.insideFunction = true;
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(SelectList segment) {
        this.target.onRendered(this.builder);
        return super.leaveMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Table) {
            this.builder.append(NameRenderer.reference(this.context, (Table)segment)).append('.');
        }
        if (segment instanceof SimpleFunction) {
            this.builder.append(")");
            if (segment instanceof Aliased) {
                this.builder.append(" AS ").append(NameRenderer.render(this.context, (Aliased)((Object)segment)));
            }
            this.insideFunction = false;
            this.requiresComma = true;
        } else if (segment instanceof AsteriskFromTable) {
            this.builder.append("*");
            this.requiresComma = true;
        } else if (segment instanceof Column) {
            this.builder.append(NameRenderer.render(this.context, (Column)segment));
            if (segment instanceof Aliased && !this.insideFunction) {
                this.builder.append(" AS ").append(NameRenderer.render(this.context, (Aliased)((Object)segment)));
            }
            this.requiresComma = true;
        } else if (segment instanceof AsteriskFromTable) {
            this.builder.append("*");
        } else if (segment instanceof Expression) {
            this.builder.append(segment.toString());
        }
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

