/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.auditing;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.util.Assert;

public class RelationalAuditingCallback
implements BeforeConvertCallback<Object>,
Ordered {
    public static final int AUDITING_ORDER = 100;
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public RelationalAuditingCallback(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null;");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    public int getOrder() {
        return 100;
    }

    @Override
    public Object onBeforeConvert(Object entity) {
        return ((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }
}

