/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.BasicRelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.BasicRelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.CachingNamingStrategy;
import org.springframework.data.relational.core.mapping.DefaultAggregatePath;
import org.springframework.data.relational.core.mapping.DefaultNamingStrategy;
import org.springframework.data.relational.core.mapping.EmbeddedContext;
import org.springframework.data.relational.core.mapping.EmbeddedRelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.EmbeddedRelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.ExpressionEvaluator;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.SqlIdentifierSanitizer;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.spel.ExtensionAwareEvaluationContextProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RelationalMappingContext
extends AbstractMappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> {
    private final NamingStrategy namingStrategy;
    private final Map<AggregatePathCacheKey, AggregatePath> aggregatePathCache = new ConcurrentHashMap<AggregatePathCacheKey, AggregatePath>();
    private boolean forceQuote = true;
    private final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(EvaluationContextProvider.DEFAULT);
    private boolean singleQueryLoadingEnabled = false;

    public RelationalMappingContext() {
        this(new DefaultNamingStrategy());
    }

    public RelationalMappingContext(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null");
        this.namingStrategy = new CachingNamingStrategy(namingStrategy);
        this.setSimpleTypeHolder(SimpleTypeHolder.DEFAULT);
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    public void setSqlIdentifierSanitizer(SqlIdentifierSanitizer sanitizer) {
        this.expressionEvaluator.setSanitizer(sanitizer);
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.expressionEvaluator.setProvider((EvaluationContextProvider)new ExtensionAwareEvaluationContextProvider((ListableBeanFactory)applicationContext));
    }

    @Nullable
    public RelationalPersistentEntity<?> getPersistentEntity(RelationalPersistentProperty persistentProperty) {
        boolean embeddedDelegation = persistentProperty instanceof EmbeddedRelationalPersistentProperty;
        RelationalPersistentEntity entity = (RelationalPersistentEntity)super.getPersistentEntity((PersistentProperty)persistentProperty);
        if (entity != null && (persistentProperty.isEmbedded() || embeddedDelegation)) {
            return new EmbeddedRelationalPersistentEntity(entity, new EmbeddedContext(persistentProperty));
        }
        return entity;
    }

    protected <T> RelationalPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicRelationalPersistentEntity<T> entity = new BasicRelationalPersistentEntity<T>(typeInformation, this.namingStrategy, this.expressionEvaluator);
        entity.setForceQuote(this.isForceQuote());
        return entity;
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicRelationalPersistentProperty persistentProperty = new BasicRelationalPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this.namingStrategy);
        this.applyDefaults(persistentProperty);
        return persistentProperty;
    }

    public boolean isSingleQueryLoadingEnabled() {
        return this.singleQueryLoadingEnabled;
    }

    public void setSingleQueryLoadingEnabled(boolean singleQueryLoadingEnabled) {
        this.singleQueryLoadingEnabled = singleQueryLoadingEnabled;
    }

    protected void applyDefaults(BasicRelationalPersistentProperty persistentProperty) {
        persistentProperty.setForceQuote(this.isForceQuote());
        persistentProperty.setExpressionEvaluator(this.expressionEvaluator);
    }

    public AggregatePath getAggregatePath(PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        AggregatePathCacheKey cacheKey = AggregatePathCacheKey.of(path);
        AggregatePath aggregatePath = this.aggregatePathCache.get(cacheKey);
        if (aggregatePath == null) {
            aggregatePath = new DefaultAggregatePath(this, path);
            this.aggregatePathCache.put(cacheKey, aggregatePath);
        }
        return aggregatePath;
    }

    public AggregatePath getAggregatePath(RelationalPersistentEntity<?> type) {
        AggregatePathCacheKey cacheKey = AggregatePathCacheKey.of(type);
        AggregatePath aggregatePath = this.aggregatePathCache.get(cacheKey);
        if (aggregatePath == null) {
            aggregatePath = new DefaultAggregatePath(this, type);
            this.aggregatePathCache.put(cacheKey, aggregatePath);
        }
        return aggregatePath;
    }

    private record AggregatePathCacheKey(RelationalPersistentEntity<?> root, @Nullable PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        static AggregatePathCacheKey of(RelationalPersistentEntity<?> root) {
            return new AggregatePathCacheKey(root, null);
        }

        static AggregatePathCacheKey of(PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
            return new AggregatePathCacheKey(((RelationalPersistentProperty)path.getBaseProperty()).getOwner(), path);
        }
    }
}

