/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sqlgeneration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;

public class AliasFactory {
    private final SingleAliasFactory columnAliases = new SingleAliasFactory("c");
    private final SingleAliasFactory tableAliases = new SingleAliasFactory("t");
    private final SingleAliasFactory rowNumberAliases = new SingleAliasFactory("rn");
    private final SingleAliasFactory rowCountAliases = new SingleAliasFactory("rc");
    private final SingleAliasFactory backReferenceAliases = new SingleAliasFactory("br");
    private final SingleAliasFactory keyAliases = new SingleAliasFactory("key");
    private final AtomicInteger counter = new AtomicInteger();

    private static String sanitize(String name) {
        return name.replaceAll("\\W", "");
    }

    public String getColumnAlias(AggregatePath path) {
        return this.columnAliases.getOrCreateFor(path);
    }

    public String getTableAlias(AggregatePath path) {
        return this.tableAliases.getOrCreateFor(path);
    }

    public String getRowNumberAlias(AggregatePath path) {
        return this.rowNumberAliases.getOrCreateFor(AggregatePathTraversal.getTableOwningPath(path));
    }

    public String getRowCountAlias(AggregatePath path) {
        return this.rowCountAliases.getOrCreateFor(path);
    }

    public String getBackReferenceAlias(AggregatePath path) {
        return this.backReferenceAliases.getOrCreateFor(path);
    }

    public String getKeyAlias(AggregatePath path) {
        return this.keyAliases.getOrCreateFor(path);
    }

    private static String getName(AggregatePath path) {
        return AliasFactory.sanitize(path.isEntity() ? path.getTableInfo().qualifiedTableName().getReference() : path.getColumnInfo().name().getReference()).toLowerCase();
    }

    private class SingleAliasFactory {
        private final String prefix;
        private final Map<AggregatePath, String> cache = new ConcurrentHashMap<AggregatePath, String>();

        SingleAliasFactory(String prefix) {
            this.prefix = prefix + "_";
        }

        String getOrCreateFor(AggregatePath path) {
            return this.cache.computeIfAbsent(path, this::createName);
        }

        private String createName(AggregatePath path) {
            return this.prefix + AliasFactory.getName(path) + "_" + AliasFactory.this.counter.incrementAndGet();
        }
    }
}

