/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

public interface DbAction<T> {
    public Class<T> getEntityType();

    public static interface WithPropertyPath<T>
    extends DbAction<T> {
        public PersistentPropertyPath<RelationalPersistentProperty> propertyPath();

        @Override
        default public Class<T> getEntityType() {
            return ((RelationalPersistentProperty)this.propertyPath().getLeafProperty()).getActualType();
        }
    }

    public static interface WithRoot<T>
    extends WithEntity<T> {
        public void setEntity(T var1);
    }

    public static interface WithEntity<T>
    extends DbAction<T> {
        public T entity();

        @Override
        default public Class<T> getEntityType() {
            return this.entity().getClass();
        }

        public IdValueSource idValueSource();
    }

    public static interface WithDependingOn<T>
    extends WithPropertyPath<T>,
    WithEntity<T> {
        public WithEntity<?> dependingOn();

        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers();

        default public @Nullable Pair<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifier() {
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = this.qualifiers();
            if (qualifiers.isEmpty()) {
                return null;
            }
            Set<Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, Object>> entries = qualifiers.entrySet();
            Optional<Map.Entry> optionalEntry = entries.stream().filter(e -> e.getValue() != null).min(Comparator.comparing(e -> -((PersistentPropertyPath)e.getKey()).getLength()));
            Map.Entry entry = optionalEntry.orElse(null);
            if (entry == null) {
                return null;
            }
            return Pair.of((Object)((PersistentPropertyPath)entry.getKey()), entry.getValue());
        }

        @Override
        default public Class<T> getEntityType() {
            return WithEntity.super.getEntityType();
        }
    }

    public static final class BatchDeleteRoot<T>
    extends BatchWithValue<T, DeleteRoot<T>, Class<T>> {
        BatchDeleteRoot(List<DeleteRoot<T>> actions) {
            super(actions, DeleteRoot::getEntityType);
        }
    }

    public static final class BatchDelete<T>
    extends BatchWithValue<T, Delete<T>, PersistentPropertyPath<RelationalPersistentProperty>> {
        public BatchDelete(List<Delete<T>> actions) {
            super(actions, Delete::propertyPath);
        }
    }

    public static final class BatchInsertRoot<T>
    extends BatchWithValue<T, InsertRoot<T>, IdValueSource> {
        public BatchInsertRoot(List<InsertRoot<T>> actions) {
            super(actions, InsertRoot::idValueSource);
        }
    }

    public static final class BatchInsert<T>
    extends BatchWithValue<T, Insert<T>, IdValueSource> {
        public BatchInsert(List<Insert<T>> actions) {
            super(actions, Insert::idValueSource);
        }
    }

    public static abstract class BatchWithValue<T, A extends DbAction<T>, B>
    implements DbAction<T> {
        private final List<A> actions;
        private final B batchValue;

        BatchWithValue(List<A> actions, Function<A, B> batchValueExtractor) {
            Assert.notEmpty(actions, (String)"Actions must contain at least one action");
            Iterator<A> actionIterator = actions.iterator();
            this.batchValue = batchValueExtractor.apply((DbAction)actionIterator.next());
            actionIterator.forEachRemaining(action -> Assert.isTrue((boolean)batchValueExtractor.apply(action).equals(this.batchValue), (String)"All actions in the batch must have matching batchValue"));
            this.actions = actions;
        }

        @Override
        public Class<T> getEntityType() {
            return ((DbAction)this.actions.get(0)).getEntityType();
        }

        public List<A> getActions() {
            return this.actions;
        }

        public B getBatchValue() {
            return this.batchValue;
        }

        public String toString() {
            return "BatchWithValue{actions=" + String.valueOf(this.actions) + ", batchValue=" + String.valueOf(this.batchValue) + "}";
        }
    }

    public static final class AcquireLockAllRoot<T>
    implements DbAction<T> {
        private final Class<T> entityType;

        AcquireLockAllRoot(Class<T> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockAllRoot(entityType=" + String.valueOf(this.getEntityType()) + ")";
        }
    }

    public static final class AcquireLockRoot<T>
    implements DbAction<T> {
        private final Object id;
        private final Class<T> entityType;

        AcquireLockRoot(Object id, Class<T> entityType) {
            this.id = id;
            this.entityType = entityType;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockRoot(id=" + String.valueOf(this.getId()) + ", entityType=" + String.valueOf(this.getEntityType()) + ")";
        }
    }

    public record DeleteAllRoot<T>(Class<T> getEntityType) implements DbAction<T>
    {
        @Override
        public String toString() {
            return "DbAction.DeleteAllRoot(entityType=" + String.valueOf(this.getEntityType()) + ")";
        }
    }

    public record DeleteAll<T>(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) implements WithPropertyPath<T>
    {
        @Override
        public String toString() {
            return "DbAction.DeleteAll(propertyPath=" + String.valueOf(this.propertyPath()) + ")";
        }
    }

    public record DeleteRoot<T>(Object id, Class<T> getEntityType, @Nullable Number previousVersion) implements DbAction<T>
    {
        @Override
        public String toString() {
            return "DbAction.DeleteRoot(id=" + String.valueOf(this.id()) + ", entityType=" + String.valueOf(this.getEntityType()) + ", previousVersion=" + String.valueOf(this.previousVersion()) + ")";
        }
    }

    public record Delete<T>(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) implements WithPropertyPath<T>
    {
        @Override
        public String toString() {
            return "DbAction.Delete(rootId=" + String.valueOf(this.rootId()) + ", propertyPath=" + String.valueOf(this.propertyPath()) + ")";
        }
    }

    public static class UpdateRoot<T>
    implements WithRoot<T> {
        private T entity;
        private final @Nullable Number previousVersion;

        public UpdateRoot(T entity, @Nullable Number previousVersion) {
            this.entity = entity;
            this.previousVersion = previousVersion;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        public void setEntity(T entity) {
            this.entity = entity;
        }

        @Override
        public IdValueSource idValueSource() {
            return IdValueSource.PROVIDED;
        }

        public @Nullable Number getPreviousVersion() {
            return this.previousVersion;
        }

        public String toString() {
            return "DbAction.UpdateRoot(entity=" + String.valueOf(this.entity()) + ")";
        }
    }

    public static class InsertRoot<T>
    implements WithRoot<T> {
        private T entity;
        private final IdValueSource idValueSource;

        public InsertRoot(T entity, IdValueSource idValueSource) {
            this.entity = entity;
            this.idValueSource = idValueSource;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        public void setEntity(T entity) {
            this.entity = entity;
        }

        @Override
        public IdValueSource idValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "InsertRoot{entity=" + String.valueOf(this.entity) + ", idValueSource=" + String.valueOf((Object)this.idValueSource) + "}";
        }
    }

    public record Insert<T>(T entity, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, WithEntity<?> dependingOn, Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers, IdValueSource idValueSource) implements WithDependingOn<T>
    {
        public Insert(T entity, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, WithEntity<?> dependingOn, Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers, IdValueSource idValueSource) {
            this.entity = entity;
            this.propertyPath = propertyPath;
            this.dependingOn = dependingOn;
            this.qualifiers = Map.copyOf(qualifiers);
            this.idValueSource = idValueSource;
        }

        @Override
        public Class<T> getEntityType() {
            return WithDependingOn.super.getEntityType();
        }

        @Override
        public String toString() {
            return "Insert{entity=" + String.valueOf(this.entity) + ", propertyPath=" + String.valueOf(this.propertyPath) + ", dependingOn=" + String.valueOf(this.dependingOn) + ", idValueSource=" + String.valueOf((Object)this.idValueSource) + ", qualifiers=" + String.valueOf(this.qualifiers) + "}";
        }
    }
}

