/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.BatchedActions;
import org.springframework.data.relational.core.conversion.BatchingAggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DeleteAggregateChange;

public class DeleteBatchingAggregateChange<T>
implements BatchingAggregateChange<T, DeleteAggregateChange<T>> {
    private final Class<T> entityType;
    private final List<DbAction.DeleteRoot<T>> rootActionsWithoutVersion = new ArrayList<DbAction.DeleteRoot<T>>();
    private final List<DbAction.DeleteRoot<T>> rootActionsWithVersion = new ArrayList<DbAction.DeleteRoot<T>>();
    private final List<DbAction.AcquireLockRoot<?>> lockActions = new ArrayList();
    private final BatchedActions deleteActions = BatchedActions.batchedDeletes();

    DeleteBatchingAggregateChange(Class<T> entityType) {
        this.entityType = entityType;
    }

    @Override
    public AggregateChange.Kind getKind() {
        return AggregateChange.Kind.DELETE;
    }

    @Override
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Override
    public void forEachAction(Consumer<? super DbAction<?>> consumer) {
        this.lockActions.forEach(consumer);
        this.deleteActions.forEach(consumer);
        if (this.rootActionsWithoutVersion.size() > 1) {
            consumer.accept(new DbAction.BatchDeleteRoot<T>(this.rootActionsWithoutVersion));
        } else {
            this.rootActionsWithoutVersion.forEach(consumer);
        }
        this.rootActionsWithVersion.forEach(consumer);
    }

    @Override
    public void add(DeleteAggregateChange<T> aggregateChange) {
        aggregateChange.forEachAction(action -> {
            if (action instanceof DbAction.DeleteRoot) {
                DbAction.DeleteRoot deleteRootAction = (DbAction.DeleteRoot)action;
                this.addDeleteRoot(deleteRootAction);
            } else if (action instanceof DbAction.Delete) {
                DbAction.Delete deleteAction = (DbAction.Delete)action;
                this.deleteActions.add(deleteAction);
            } else if (action instanceof DbAction.AcquireLockRoot) {
                DbAction.AcquireLockRoot lockRootAction = (DbAction.AcquireLockRoot)action;
                this.lockActions.add(lockRootAction);
            }
        });
    }

    private void addDeleteRoot(DbAction.DeleteRoot<T> action) {
        if (action.previousVersion() == null) {
            this.rootActionsWithoutVersion.add(action);
        } else {
            this.rootActionsWithVersion.add(action);
        }
    }
}

