/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.DefaultUpdate;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.UpdateBuilder;
import org.springframework.util.Assert;

class DefaultUpdateBuilder
implements UpdateBuilder,
UpdateBuilder.UpdateWhere,
UpdateBuilder.UpdateWhereAndOr,
UpdateBuilder.UpdateAssign {
    private @Nullable Table table;
    private final List<Assignment> assignments = new ArrayList<Assignment>();
    private @Nullable Condition where;

    DefaultUpdateBuilder() {
    }

    @Override
    public UpdateBuilder.UpdateAssign table(Table table) {
        Assert.notNull((Object)table, (String)"Table must not be null");
        this.table = table;
        return this;
    }

    @Override
    public DefaultUpdateBuilder set(Assignment assignment) {
        Assert.notNull((Object)assignment, (String)"Assignment must not be null");
        this.assignments.add(assignment);
        return this;
    }

    @Override
    public UpdateBuilder.UpdateWhere set(Assignment ... assignments) {
        Assert.notNull((Object)assignments, (String)"Assignment must not be null");
        return this.set(Arrays.asList(assignments));
    }

    @Override
    public UpdateBuilder.UpdateWhere set(Collection<? extends Assignment> assignments) {
        Assert.notNull(assignments, (String)"Assignment must not be null");
        this.assignments.addAll(assignments);
        return this;
    }

    @Override
    public UpdateBuilder.UpdateWhereAndOr where(Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        this.where = condition;
        return this;
    }

    @Override
    public UpdateBuilder.UpdateWhereAndOr and(Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.state((this.where != null ? 1 : 0) != 0, (String)"Where must not be null");
        this.where = this.where.and(condition);
        return this;
    }

    @Override
    public UpdateBuilder.UpdateWhereAndOr or(Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.state((this.where != null ? 1 : 0) != 0, (String)"Where must not be null");
        this.where = this.where.and(condition);
        return this;
    }

    @Override
    public Update build() {
        Assert.state((this.table != null ? 1 : 0) != 0, (String)"Table must not be null");
        return new DefaultUpdate(this.table, this.assignments, this.where);
    }
}

