/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;

public class SimpleFacetAndHighlightQuery
extends SimpleQuery
implements FacetAndHighlightQuery {
    private FacetOptions facetOptions;
    private HighlightOptions highlightOptions;

    public SimpleFacetAndHighlightQuery() {
    }

    public SimpleFacetAndHighlightQuery(Criteria criteria) {
        this(criteria, null);
    }

    public SimpleFacetAndHighlightQuery(Criteria criteria, Pageable pageable) {
        super(criteria, pageable);
    }

    @Override
    public final <T extends SolrDataQuery> T setFacetOptions(FacetOptions facetOptions) {
        if (facetOptions != null) {
            Assert.isTrue((boolean)facetOptions.hasFacets(), (String)"Cannot set facet options having neither fields nor queries.");
        }
        this.facetOptions = facetOptions;
        return (T)this;
    }

    @Override
    public FacetOptions getFacetOptions() {
        return this.facetOptions;
    }

    @Override
    public boolean hasFacetOptions() {
        return this.getFacetOptions() != null;
    }

    @Override
    public <T extends SolrDataQuery> T setHighlightOptions(HighlightOptions highlightOptions) {
        this.highlightOptions = highlightOptions;
        return (T)this;
    }

    @Override
    public HighlightOptions getHighlightOptions() {
        return this.highlightOptions;
    }

    @Override
    public boolean hasHighlightOptions() {
        return this.highlightOptions != null;
    }
}

