/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class SolrJsonResponse
extends SolrResponseBase {
    private static final long serialVersionUID = 5727953031460362404L;
    private JsonNode root;
    private ObjectMapper mapper = new ObjectMapper();

    public SolrJsonResponse() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public void setResponse(NamedList<Object> response) {
        super.setResponse(response);
        try {
            String json = this.getJsonResponse();
            if (json == null) {
                this.root = response.get("version") != null ? this.mapper.readTree(response.toString().replace('=', ':')) : this.mapper.createObjectNode();
                return;
            }
            this.root = this.mapper.readTree(json);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Unable to parse json from response.", (Throwable)e);
        }
    }

    public String getJsonResponse() {
        return (String)this.getResponse().get("json");
    }

    public JsonNode getNode(String name) {
        return this.root.findValue(name);
    }
}

