/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.data.solr.server.support.SolrClientUtils;

abstract class SolrClientFactoryBase
implements SolrClientFactory,
DisposableBean {
    private SolrClient solrClient;

    public SolrClientFactoryBase() {
    }

    SolrClientFactoryBase(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    protected final boolean isHttpSolrClient(SolrClient solrClient) {
        return solrClient instanceof HttpSolrClient;
    }

    @Override
    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public void destroy() {
        this.destroy(this.solrClient);
    }

    protected void destroy(SolrClient client) {
        SolrClientUtils.close(client);
    }
}

