/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;

public interface SpellcheckQueryResult {
    public Collection<Alternative> getAlternatives();

    public Collection<Alternative> getAlternatives(String var1);

    public Collection<String> getSuggestions();

    public Collection<String> getSuggestions(String var1);

    public void addSuggestions(String var1, List<Alternative> var2);

    public static class Alternative {
        private final String term;
        private final int termFrequency;
        private final String suggestion;
        private final int suggestionFrequency;

        @ConstructorProperties(value={"term", "termFrequency", "suggestion", "suggestionFrequency"})
        public Alternative(String term, int termFrequency, String suggestion, int suggestionFrequency) {
            this.term = term;
            this.termFrequency = termFrequency;
            this.suggestion = suggestion;
            this.suggestionFrequency = suggestionFrequency;
        }

        public String getTerm() {
            return this.term;
        }

        public int getTermFrequency() {
            return this.termFrequency;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public int getSuggestionFrequency() {
            return this.suggestionFrequency;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alternative)) {
                return false;
            }
            Alternative other = (Alternative)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$term = this.getTerm();
            String other$term = other.getTerm();
            if (this$term == null ? other$term != null : !this$term.equals(other$term)) {
                return false;
            }
            if (this.getTermFrequency() != other.getTermFrequency()) {
                return false;
            }
            String this$suggestion = this.getSuggestion();
            String other$suggestion = other.getSuggestion();
            if (this$suggestion == null ? other$suggestion != null : !this$suggestion.equals(other$suggestion)) {
                return false;
            }
            return this.getSuggestionFrequency() == other.getSuggestionFrequency();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Alternative;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $term = this.getTerm();
            result = result * 59 + ($term == null ? 43 : $term.hashCode());
            result = result * 59 + this.getTermFrequency();
            String $suggestion = this.getSuggestion();
            result = result * 59 + ($suggestion == null ? 43 : $suggestion.hashCode());
            result = result * 59 + this.getSuggestionFrequency();
            return result;
        }

        public String toString() {
            return "SpellcheckQueryResult.Alternative(term=" + this.getTerm() + ", termFrequency=" + this.getTermFrequency() + ", suggestion=" + this.getSuggestion() + ", suggestionFrequency=" + this.getSuggestionFrequency() + ")";
        }
    }
}

