/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class TemplateVariable
implements Serializable {
    private static final long serialVersionUID = -2731446749851863774L;
    private final String name;
    private final VariableType type;
    private final String description;

    public TemplateVariable(String name, VariableType type) {
        this(name, type, "");
    }

    public TemplateVariable(String name, VariableType type, String description) {
        Assert.hasText((String)"Variable name must not be null or empty!");
        Assert.notNull((Object)"Variable type must not be null!");
        Assert.notNull((Object)"Description must not be null!");
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return StringUtils.hasText((String)this.description);
    }

    boolean isRequired() {
        return !this.type.isOptional();
    }

    boolean isCombinable(TemplateVariable variable) {
        return this.type.canBeCombinedWith(variable.type);
    }

    boolean isEquivalent(TemplateVariable variable) {
        return this.name.equals(variable.name) && this.isCombinable(variable);
    }

    boolean isRequestParameterVariable() {
        return this.type.equals((Object)VariableType.REQUEST_PARAM) || this.type.equals((Object)VariableType.REQUEST_PARAM_CONTINUED);
    }

    boolean isFragment() {
        return this.type.equals((Object)VariableType.FRAGMENT);
    }

    public String toString() {
        String base = String.format("{%s%s}", this.type.toString(), this.name);
        return StringUtils.hasText((String)this.description) ? String.format("%s - %s", base, this.description) : base;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TemplateVariable)) {
            return false;
        }
        TemplateVariable that = (TemplateVariable)obj;
        return this.name.equals(that.name) && this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = 17;
        result += this.name.hashCode();
        return result += this.type.hashCode();
    }

    public static enum VariableType {
        PATH_VARIABLE("", false),
        REQUEST_PARAM("?", true),
        REQUEST_PARAM_CONTINUED("&", true),
        SEGMENT("/", true),
        FRAGMENT("#", true);

        private static final List<VariableType> combinableTypes;
        private final String key;
        private final boolean optional;

        private VariableType(String key, boolean optional) {
            this.key = key;
            this.optional = optional;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean canBeCombinedWith(VariableType type) {
            return this.equals((Object)type) || combinableTypes.contains((Object)this) && combinableTypes.contains((Object)type);
        }

        public static VariableType from(String key) {
            for (VariableType type : VariableType.values()) {
                if (!type.key.equals(key)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unsupported variable type " + key + "!");
        }

        public String toString() {
            return this.key;
        }

        static {
            combinableTypes = Arrays.asList(REQUEST_PARAM, REQUEST_PARAM_CONTINUED);
        }
    }
}

