/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.server.MethodLinkBuilderFactory;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.SpringAffordanceBuilder;
import org.springframework.hateoas.server.core.WebHandler;
import org.springframework.hateoas.server.mvc.UriComponentsBuilderFactory;
import org.springframework.hateoas.server.mvc.UriComponentsContributor;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.util.UriComponentsBuilder;

public class WebMvcLinkBuilderFactory
implements MethodLinkBuilderFactory<WebMvcLinkBuilder> {
    private static ConversionService FALLBACK_CONVERSION_SERVICE = new DefaultFormattingConversionService();
    private List<UriComponentsContributor> uriComponentsContributors = new ArrayList<UriComponentsContributor>();

    public void setUriComponentsContributors(List<? extends UriComponentsContributor> uriComponentsContributors) {
        this.uriComponentsContributors = Collections.unmodifiableList(uriComponentsContributors);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller) {
        return WebMvcLinkBuilder.linkTo(controller);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        return WebMvcLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Method method) {
        return WebMvcLinkBuilder.linkTo(method);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Method method, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(method, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> type, Method method) {
        return WebMvcLinkBuilder.linkTo(type, method);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(controller, method, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Object invocationValue) {
        Function<String, UriComponentsBuilder> builderFactory = mapping -> UriComponentsBuilderFactory.getBuilder().path(mapping);
        return WebHandler.linkTo(invocationValue, WebMvcLinkBuilder::new, (builder, invocation) -> {
            String[] primaryParams = SpringAffordanceBuilder.DISCOVERER.getParams(invocation.getMethod());
            ParamsRequestCondition paramsRequestCondition = new ParamsRequestCondition(primaryParams);
            for (NameValueExpression expression : paramsRequestCondition.getExpressions()) {
                String value;
                if (expression.isNegated() || (value = (String)expression.getValue()) == null) continue;
                builder.queryParam(expression.getName(), new Object[]{value});
            }
            MethodParameters parameters = MethodParameters.of(invocation.getMethod());
            Iterator<Object> parameterValues = Arrays.asList(invocation.getArguments()).iterator();
            for (MethodParameter parameter : parameters.getParameters()) {
                Object parameterValue = parameterValues.next();
                for (UriComponentsContributor contributor : this.uriComponentsContributors) {
                    if (!contributor.supportsParameter(parameter)) continue;
                    contributor.enhance((UriComponentsBuilder)builder, parameter, parameterValue);
                }
            }
            return builder;
        }, builderFactory, WebMvcLinkBuilderFactory.getConversionService());
    }

    private static Supplier<ConversionService> getConversionService() {
        return () -> {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            if (attributes == null || !ServletRequestAttributes.class.isInstance(attributes)) {
                return FALLBACK_CONVERSION_SERVICE;
            }
            ServletContext servletContext = ((ServletRequestAttributes)attributes).getRequest().getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            return context == null || !context.containsBean("mvcConversionService") ? FALLBACK_CONVERSION_SERVICE : (ConversionService)context.getBean("mvcConversionService", ConversionService.class);
        };
    }
}

