/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ContentTypeDelegatingMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.messaging.Message;

public final class MappingUtils {
    private MappingUtils() {
    }

    public static org.springframework.amqp.core.Message mapMessage(Message<?> requestMessage, MessageConverter converter, AmqpHeaderMapper headerMapper, MessageDeliveryMode defaultDeliveryMode) {
        org.springframework.amqp.core.Message amqpMessage;
        MessageProperties amqpMessageProperties = new MessageProperties();
        if (converter instanceof ContentTypeDelegatingMessageConverter) {
            headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
            amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
        } else {
            amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
            headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        }
        MappingUtils.checkDeliveryMode(requestMessage, amqpMessageProperties, defaultDeliveryMode);
        return amqpMessage;
    }

    public static void checkDeliveryMode(Message<?> requestMessage, MessageProperties messageProperties, MessageDeliveryMode defaultDeliveryMode) {
        if (defaultDeliveryMode != null && requestMessage.getHeaders().get((Object)"amqp_deliveryMode") == null) {
            messageProperties.setDeliveryMode(defaultDeliveryMode);
        }
    }
}

