/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.integration.amqp.dsl.AmqpBaseOutboundEndpointSpec;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.util.Assert;

public abstract class AmqpOutboundEndpointSpec<S extends AmqpOutboundEndpointSpec<S>>
extends AmqpBaseOutboundEndpointSpec<S, AmqpOutboundEndpoint> {
    protected final boolean expectReply;

    protected AmqpOutboundEndpointSpec(AmqpTemplate amqpTemplate, boolean expectReply) {
        this.expectReply = expectReply;
        this.target = new AmqpOutboundEndpoint(amqpTemplate);
        ((AmqpOutboundEndpoint)((Object)this.target)).setExpectReply(expectReply);
        ((AmqpOutboundEndpoint)((Object)this.target)).setHeaderMapper(this.headerMapper);
        if (expectReply) {
            ((AmqpOutboundEndpoint)((Object)this.target)).setRequiresReply(true);
        }
    }

    @Override
    public S mappedReplyHeaders(String ... headers) {
        Assert.isTrue((boolean)this.expectReply, (String)"'mappedReplyHeaders' can be applied only for gateway");
        return (S)((Object)((AmqpOutboundEndpointSpec)((Object)super.mappedReplyHeaders(headers))));
    }

    public S waitForConfirm(boolean waitForConfirm) {
        ((AmqpOutboundEndpoint)((Object)this.target)).setWaitForConfirm(waitForConfirm);
        return (S)((Object)((AmqpOutboundEndpointSpec)this._this()));
    }
}

