/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.MBeanExporter;

class MBeanExporterHelper
implements BeanPostProcessor,
Ordered {
    private final List<MBeanExporter> mBeanExportersForExcludes = new ArrayList<MBeanExporter>();
    private final Set<String> siBeanNames = new HashSet<String>();

    MBeanExporterHelper() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if ("$autoCreateChannelCandidates".equals(beanName)) {
            Collection autoCreateChannelCandidatesNames = (Collection)new DirectFieldAccessor(bean).getPropertyValue("channelNames");
            this.siBeanNames.addAll(autoCreateChannelCandidatesNames);
            if (!this.mBeanExportersForExcludes.isEmpty()) {
                for (String autoCreateChannelCandidatesName : autoCreateChannelCandidatesNames) {
                    for (MBeanExporter mBeanExporter : this.mBeanExportersForExcludes) {
                        mBeanExporter.addExcludedBean(autoCreateChannelCandidatesName);
                    }
                }
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)AopUtils.getTargetClass((Object)bean), (String)IntegrationManagedResource.class.getName())) {
            this.siBeanNames.add(beanName);
            if (!this.mBeanExportersForExcludes.isEmpty()) {
                for (MBeanExporter mBeanExporter : this.mBeanExportersForExcludes) {
                    mBeanExporter.addExcludedBean(beanName);
                }
            }
        }
        if (bean instanceof MBeanExporter && !(bean instanceof IntegrationMBeanExporter)) {
            MBeanExporter mBeanExporter = (MBeanExporter)bean;
            this.mBeanExportersForExcludes.add(mBeanExporter);
            for (String siBeanName : this.siBeanNames) {
                mBeanExporter.addExcludedBean(siBeanName);
            }
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

