/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class NotificationListeningMessageProducer
extends MessageProducerSupport
implements NotificationListener,
ApplicationListener<ContextRefreshedEvent> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicBoolean listenerRegisteredOnStartup = new AtomicBoolean();
    private volatile MBeanServerConnection server;
    private volatile ObjectName[] objectNames;
    private volatile NotificationFilter filter;
    private volatile Object handback;

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setObjectName(ObjectName ... objectNames) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])objectNames) ? 1 : 0) != 0, (String)"'objectNames' must contain at least one ObjectName");
        this.objectNames = objectNames;
    }

    public void setFilter(NotificationFilter filter) {
        this.filter = filter;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("received notification: " + notification + ", and handback: " + handback));
        }
        AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload((Object)notification);
        if (handback != null) {
            builder.setHeader("jmx_notificationHandback", handback);
        }
        Message message = builder.build();
        this.sendMessage(message);
    }

    public String getComponentType() {
        return "jmx:notification-listening-channel-adapter";
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.listenerRegisteredOnStartup.getAndSet(true) && this.isAutoStartup()) {
            this.doStart();
        }
    }

    protected void doStart() {
        if (!this.listenerRegisteredOnStartup.get()) {
            return;
        }
        this.logger.debug((Object)"Registering to receive notifications");
        try {
            Assert.notNull((Object)this.server, (String)"MBeanServer is required.");
            Assert.notNull((Object)this.objectNames, (String)"An ObjectName is required.");
            Collection<ObjectName> objectNames = this.retrieveMBeanNames();
            if (objectNames.size() < 1) {
                this.logger.error((Object)("No MBeans found matching ObjectName pattern(s): " + Arrays.asList(this.objectNames)));
            }
            for (ObjectName objectName : objectNames) {
                this.server.addNotificationListener(objectName, this, this.filter, this.handback);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Failed to find MBean instance.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException on MBeanServerConnection.", e);
        }
    }

    protected void doStop() {
        this.logger.debug((Object)"Unregistering notifications");
        if (this.server != null && this.objectNames != null) {
            Collection<ObjectName> objectNames = this.retrieveMBeanNames();
            for (ObjectName objectName : objectNames) {
                try {
                    this.server.removeNotificationListener(objectName, this, this.filter, this.handback);
                }
                catch (InstanceNotFoundException e) {
                    this.logger.error((Object)"Failed to find MBean instance.", (Throwable)e);
                }
                catch (ListenerNotFoundException e) {
                    this.logger.error((Object)"Failed to find NotificationListener.", (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error((Object)"IOException on MBeanServerConnection.", (Throwable)e);
                }
            }
        }
    }

    protected Collection<ObjectName> retrieveMBeanNames() {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (ObjectName pattern : this.objectNames) {
            Set<ObjectInstance> mBeanInfos;
            try {
                mBeanInfos = this.server.queryMBeans(pattern, null);
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException on MBeanServerConnection.", e);
            }
            if (mBeanInfos.size() == 0 && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No MBeans found matching pattern:" + pattern));
            }
            for (ObjectInstance instance : mBeanInfos) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found MBean:" + instance.getObjectName().toString()));
                }
                objectNames.add(instance.getObjectName());
            }
        }
        return objectNames;
    }
}

