/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.stream.StreamClosedEvent;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class CharacterStreamReadingMessageSource
extends AbstractMessageSource<String>
implements ApplicationEventPublisherAware {
    private final BufferedReader reader;
    private final boolean blockToDetectEOF;
    private ApplicationEventPublisher applicationEventPublisher;

    public CharacterStreamReadingMessageSource(Reader reader) {
        this(reader, -1, false);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize) {
        this(reader, bufferSize, false);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize, boolean blockToDetectEOF) {
        Assert.notNull((Object)reader, (String)"reader must not be null");
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : (bufferSize > 0 ? new BufferedReader(reader, bufferSize) : new BufferedReader(reader));
        this.blockToDetectEOF = blockToDetectEOF;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public String getComponentType() {
        return "stream:stdin-channel-adapter(character)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doReceive() {
        try {
            BufferedReader bufferedReader = this.reader;
            synchronized (bufferedReader) {
                if (!this.blockToDetectEOF && !this.reader.ready()) {
                    return null;
                }
                String line = this.reader.readLine();
                if (line == null && this.applicationEventPublisher != null) {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new StreamClosedEvent((Object)this));
                }
                return line;
            }
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }

    public static final CharacterStreamReadingMessageSource stdin() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in));
    }

    public static final CharacterStreamReadingMessageSource stdin(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }

    public static final CharacterStreamReadingMessageSource stdinPipe() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in), -1, true);
    }

    public static final CharacterStreamReadingMessageSource stdinPipe(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName), -1, true);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

