/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.tuple;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.tuple.Tuple;
import org.springframework.tuple.TupleBuilder;

public class JsonToTupleTransformer
extends AbstractPayloadTransformer<String, Tuple> {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonToTupleTransformer() {
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public Tuple transformPayload(String json) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        JsonNode node = this.mapper.readTree(json);
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String name = (String)fieldNames.next();
            JsonNode valueNode = node.get(name);
            Object value = this.mapper.treeToValue((TreeNode)valueNode, Object.class);
            names.add(name);
            values.add(value);
        }
        return TupleBuilder.tuple().ofNamesAndValues(names, values);
    }
}

