/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.Method;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordMessagingMessageListenerAdapter;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodKafkaListenerEndpoint<K, V>
extends AbstractKafkaListenerEndpoint<K, V> {
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    protected MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    @Override
    protected MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer container, MessageConverter messageConverter) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter<K, V> messageListener = this.createMessageListenerInstance(messageConverter);
        messageListener.setHandlerMethod(this.configureListenerAdapter(messageListener));
        return messageListener;
    }

    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected MessagingMessageListenerAdapter<K, V> createMessageListenerInstance(MessageConverter messageConverter) {
        if (this.isBatchListener()) {
            BatchMessagingMessageListenerAdapter messageListener = new BatchMessagingMessageListenerAdapter(this.bean, this.method);
            if (messageConverter instanceof BatchMessageConverter) {
                messageListener.setBatchMessageConverter((BatchMessageConverter)messageConverter);
            }
            return messageListener;
        }
        RecordMessagingMessageListenerAdapter messageListener = new RecordMessagingMessageListenerAdapter(this.bean, this.method);
        if (messageConverter instanceof RecordMessageConverter) {
            messageListener.setMessageConverter((RecordMessageConverter)messageConverter);
        }
        return messageListener;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }
}

