/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.header.Headers;
import org.springframework.kafka.support.converter.AbstractJavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;

public class DefaultJackson2JavaTypeMapper
extends AbstractJavaTypeMapper
implements Jackson2JavaTypeMapper {
    private static final List<String> TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private volatile Jackson2JavaTypeMapper.TypePrecedence typePrecedence = Jackson2JavaTypeMapper.TypePrecedence.INFERRED;

    @Override
    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    @Override
    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    @Override
    public void addTrustedPackages(String ... packagesToTrust) {
        if (packagesToTrust != null) {
            for (String whiteListClass : packagesToTrust) {
                if ("*".equals(whiteListClass)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(whiteListClass);
            }
        }
    }

    @Override
    public JavaType toJavaType(Headers headers) {
        String typeIdHeader = this.retrieveHeaderAsString(headers, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            JavaType classType = this.getClassIdType(typeIdHeader);
            if (!classType.isContainerType() || classType.isArrayType()) {
                return classType;
            }
            JavaType contentClassType = this.getClassIdType(this.retrieveHeader(headers, this.getContentClassIdFieldName()));
            if (classType.getKeyType() == null) {
                return TypeFactory.defaultInstance().constructCollectionLikeType(classType.getRawClass(), contentClassType);
            }
            JavaType keyClassType = this.getClassIdType(this.retrieveHeader(headers, this.getKeyClassIdFieldName()));
            return TypeFactory.defaultInstance().constructMapLikeType(classType.getRawClass(), keyClassType, contentClassType);
        }
        return null;
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return TypeFactory.defaultInstance().constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + this.trustedPackages + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", (Throwable)e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!PatternMatchUtils.simpleMatch((String)trustedPackage, (String)packageName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fromJavaType(JavaType javaType, Headers headers) {
        String classIdFieldName = this.getClassIdFieldName();
        if (headers.lastHeader(classIdFieldName) != null) {
            this.removeHeaders(headers);
        }
        this.addHeader(headers, classIdFieldName, javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(headers, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(headers, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, Headers headers) {
        this.fromJavaType(TypeFactory.defaultInstance().constructType(clazz), headers);
    }

    @Override
    public Class<?> toClass(Headers headers) {
        return this.toJavaType(headers).getRawClass();
    }

    @Override
    public void removeHeaders(Headers headers) {
        try {
            headers.remove(this.getClassIdFieldName());
            headers.remove(this.getContentClassIdFieldName());
            headers.remove(this.getKeyClassIdFieldName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

