/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.util.Assert;

public abstract class AbstractKafkaBackOffManagerFactory
implements KafkaBackOffManagerFactory,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ListenerContainerRegistry listenerContainerRegistry;

    public AbstractKafkaBackOffManagerFactory(ListenerContainerRegistry listenerContainerRegistry) {
        this.listenerContainerRegistry = listenerContainerRegistry;
    }

    public AbstractKafkaBackOffManagerFactory() {
        this.listenerContainerRegistry = null;
    }

    public void setListenerContainerRegistry(ListenerContainerRegistry listenerContainerRegistry) {
        this.listenerContainerRegistry = listenerContainerRegistry;
    }

    @Override
    public KafkaConsumerBackoffManager create() {
        return this.doCreateManager(this.getListenerContainerRegistry());
    }

    protected abstract KafkaConsumerBackoffManager doCreateManager(ListenerContainerRegistry var1);

    protected ListenerContainerRegistry getListenerContainerRegistry() {
        return this.listenerContainerRegistry != null ? this.listenerContainerRegistry : this.getListenerContainerFromContext();
    }

    private ListenerContainerRegistry getListenerContainerFromContext() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext not set.");
        return (ListenerContainerRegistry)this.applicationContext.getBean("org.springframework.kafka.config.internalKafkaListenerEndpointRegistry", ListenerContainerRegistry.class);
    }

    protected <T> T getBean(String beanName, Class<T> beanClass) {
        return (T)this.applicationContext.getBean(beanName, beanClass);
    }

    protected void addApplicationListener(ApplicationListener<?> applicationListener) {
        ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener(applicationListener);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

