/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.kafka.KafkaStreamsMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

public class KafkaStreamsMicrometerListener
implements StreamsBuilderFactoryBean.Listener {
    private final MeterRegistry meterRegistry;
    private final List<Tag> tags;
    private final Map<String, KafkaStreamsMetrics> metrics = new HashMap<String, KafkaStreamsMetrics>();

    public KafkaStreamsMicrometerListener(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public KafkaStreamsMicrometerListener(MeterRegistry meterRegistry, List<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    @Override
    public synchronized void streamsAdded(String id, KafkaStreams kafkaStreams) {
        if (!this.metrics.containsKey(id)) {
            ArrayList<Tag> streamsTags = new ArrayList<Tag>(this.tags);
            streamsTags.add((Tag)new ImmutableTag("spring.id", id));
            this.metrics.put(id, new KafkaStreamsMetrics(kafkaStreams, streamsTags));
            this.metrics.get(id).bindTo(this.meterRegistry);
        }
    }

    @Override
    public synchronized void streamsRemoved(String id, KafkaStreams streams) {
        KafkaStreamsMetrics removed = this.metrics.remove(id);
        if (removed != null) {
            removed.close();
        }
    }
}

