/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.adapter.AdapterUtils;
import org.springframework.kafka.listener.adapter.ConsumerRecordMetadata;
import org.springframework.kafka.listener.adapter.InvocationResult;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;

public class DelegatingInvocableHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final ConcurrentMap<InvocableHandlerMethod, MethodParameter> payloadMethodParameters = new ConcurrentHashMap<InvocableHandlerMethod, MethodParameter>();
    private final InvocableHandlerMethod defaultHandler;
    private final Map<InvocableHandlerMethod, Expression> handlerSendTo = new ConcurrentHashMap<InvocableHandlerMethod, Expression>();
    private final Map<InvocableHandlerMethod, Boolean> handlerReturnsMessage = new ConcurrentHashMap<InvocableHandlerMethod, Boolean>();
    private final Map<InvocableHandlerMethod, Boolean> handlerMetadataAware = new ConcurrentHashMap<InvocableHandlerMethod, Boolean>();
    private final Object bean;
    private final BeanExpressionResolver resolver;
    private final BeanExpressionContext beanExpressionContext;
    private final ConfigurableListableBeanFactory beanFactory;
    private final PayloadValidator validator;

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, @Nullable InvocableHandlerMethod defaultHandler, Object bean, @Nullable BeanExpressionResolver beanExpressionResolver, @Nullable BeanExpressionContext beanExpressionContext, @Nullable BeanFactory beanFactory, @Nullable Validator validator) {
        ConfigurableListableBeanFactory configurableListableBeanFactory;
        this.handlers = new ArrayList<InvocableHandlerMethod>(handlers);
        for (InvocableHandlerMethod handler : handlers) {
            this.checkSpecial(handler);
        }
        this.defaultHandler = defaultHandler;
        this.checkSpecial(defaultHandler);
        this.bean = bean;
        this.resolver = beanExpressionResolver;
        this.beanExpressionContext = beanExpressionContext;
        this.beanFactory = beanFactory instanceof ConfigurableListableBeanFactory ? (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory) : null;
        this.validator = validator == null ? null : new PayloadValidator(validator);
    }

    private void checkSpecial(@Nullable InvocableHandlerMethod handler) {
        Parameter[] parameters;
        if (handler == null) {
            return;
        }
        for (Parameter parameter : parameters = handler.getMethod().getParameters()) {
            if (!ConsumerRecordMetadata.class.equals(parameter.getType())) continue;
            this.handlerMetadataAware.put(handler, true);
            return;
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        Object result;
        MethodParameter parameter;
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        if (this.validator != null && this.defaultHandler != null && (parameter = (MethodParameter)this.payloadMethodParameters.get(handler)) != null) {
            this.validator.validate(message, parameter, message.getPayload());
        }
        if (Boolean.TRUE.equals(this.handlerMetadataAware.get(handler))) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = AdapterUtils.buildConsumerRecordMetadataFromArray(providedArgs);
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            result = handler.invoke(message, args);
        } else {
            result = handler.invoke(message, providedArgs);
        }
        Expression replyTo = this.handlerSendTo.get(handler);
        return new InvocationResult(result, replyTo, this.handlerReturnsMessage.get(handler));
    }

    protected InvocableHandlerMethod getHandlerForPayload(Class<?> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new KafkaException("No method found for " + payloadClass);
            }
            this.setupReplyTo(handler);
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
        }
        return handler;
    }

    private void setupReplyTo(InvocableHandlerMethod handler) {
        String replyTo = null;
        Method method = handler.getMethod();
        SendTo ann = null;
        if (method != null) {
            ann = (SendTo)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, SendTo.class);
            replyTo = this.extractSendTo(method.toString(), ann);
        }
        if (ann == null) {
            Class beanType = handler.getBeanType();
            ann = (SendTo)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, SendTo.class);
            replyTo = this.extractSendTo(beanType.getSimpleName(), ann);
        }
        if (ann != null && replyTo == null) {
            replyTo = AdapterUtils.getDefaultReplyTopicExpression();
        }
        if (replyTo != null) {
            this.handlerSendTo.put(handler, PARSER.parseExpression(replyTo, AdapterUtils.PARSER_CONTEXT));
        }
        this.handlerReturnsMessage.put(handler, KafkaUtils.returnTypeMessageOrCollectionOf(method));
    }

    @Nullable
    private String extractSendTo(String element, @Nullable SendTo ann) {
        Object replyTo = null;
        if (ann != null) {
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + element + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            Object object = replyTo = destinations.length == 1 ? destinations[0] : null;
            if (replyTo != null && this.beanFactory != null && (replyTo = this.beanFactory.resolveEmbeddedValue((String)replyTo)) != null) {
                replyTo = this.resolve((String)replyTo);
            }
        }
        return replyTo;
    }

    private String resolve(String value) {
        if (this.resolver != null && this.beanExpressionContext != null) {
            Object newValue = this.resolver.evaluate(value, this.beanExpressionContext);
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    @Nullable
    protected InvocableHandlerMethod findHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null && !result.equals((Object)this.defaultHandler)) {
                if (handler.equals((Object)this.defaultHandler)) continue;
                throw new KafkaException("Ambiguous methods for payload type: " + payloadClass + ": " + result.getMethod().getName() + " and " + handler.getMethod().getName());
            }
            result = handler;
        }
        return result != null ? result : this.defaultHandler;
    }

    protected boolean matchHandlerMethod(Class<?> payloadClass, InvocableHandlerMethod handler) {
        Method method = handler.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1) {
            MethodParameter methodParameter = new MethodParameter(method, 0);
            boolean isPayload = this.assignPayload(methodParameter, payloadClass);
            if (isPayload && this.validator != null) {
                this.payloadMethodParameters.put(handler, methodParameter);
            }
            return isPayload;
        }
        MethodParameter foundCandidate = this.findCandidate(payloadClass, method, parameterAnnotations);
        if (foundCandidate != null && this.validator != null) {
            this.payloadMethodParameters.put(handler, foundCandidate);
        }
        return foundCandidate != null;
    }

    @Nullable
    private MethodParameter findCandidate(Class<?> payloadClass, Method method, Annotation[][] parameterAnnotations) {
        MethodParameter foundCandidate = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            if (!this.assignPayload(methodParameter, payloadClass)) continue;
            if (foundCandidate != null) {
                throw new KafkaException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = methodParameter;
        }
        return foundCandidate;
    }

    public String getMethodNameFor(Object payload) {
        InvocableHandlerMethod handlerForPayload = this.getHandlerForPayload(payload.getClass());
        return handlerForPayload == null ? "no match" : handlerForPayload.getMethod().toGenericString();
    }

    public boolean hasDefaultHandler() {
        return this.defaultHandler != null;
    }

    private boolean assignPayload(MethodParameter methodParameter, Class<?> payloadClass) {
        return (methodParameter.getParameterAnnotations().length == 0 || !methodParameter.hasParameterAnnotation(Header.class)) && methodParameter.getParameterType().isAssignableFrom(payloadClass);
    }

    private static final class PayloadValidator
    extends PayloadMethodArgumentResolver {
        PayloadValidator(Validator validator) {
            super(new MessageConverter(){

                @Nullable
                public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
                    return null;
                }

                @Nullable
                public Object fromMessage(Message<?> message, Class<?> targetClass) {
                    return null;
                }
            }, validator);
        }

        public void validate(Message<?> message, MethodParameter parameter, Object target) {
            super.validate(message, parameter, target);
        }
    }
}

