/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Bytes;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.DefaultKafkaHeaderMapper;
import org.springframework.kafka.support.JacksonPresent;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.KafkaMessageHeaders;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class BatchMessagingMessageConverter
implements BatchMessageConverter {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final RecordMessageConverter recordConverter;
    private boolean generateMessageId = false;
    private boolean generateTimestamp = false;
    private KafkaHeaderMapper headerMapper;
    private boolean rawRecordHeader;

    public BatchMessagingMessageConverter() {
        this(null);
    }

    public BatchMessagingMessageConverter(RecordMessageConverter recordConverter) {
        this.recordConverter = recordConverter;
        if (JacksonPresent.isJackson2Present()) {
            this.headerMapper = new DefaultKafkaHeaderMapper();
        }
    }

    public void setGenerateMessageId(boolean generateMessageId) {
        this.generateMessageId = generateMessageId;
    }

    public void setGenerateTimestamp(boolean generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    public void setHeaderMapper(KafkaHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    @Override
    public RecordMessageConverter getRecordMessageConverter() {
        return this.recordConverter;
    }

    public void setRawRecordHeader(boolean rawRecordHeader) {
        this.rawRecordHeader = rawRecordHeader;
    }

    @Override
    public Message<?> toMessage(List<ConsumerRecord<?, ?>> records, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer, Type type) {
        KafkaMessageHeaders kafkaMessageHeaders = new KafkaMessageHeaders(this.generateMessageId, this.generateTimestamp);
        Map<String, Object> rawHeaders = kafkaMessageHeaders.getRawHeaders();
        ArrayList<Object> payloads = new ArrayList<Object>();
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        ArrayList<String> timestampTypes = new ArrayList<String>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        ArrayList<Map<String, Object>> convertedHeaders = new ArrayList<Map<String, Object>>();
        ArrayList<Headers> natives = new ArrayList<Headers>();
        ArrayList raws = new ArrayList();
        ArrayList<ConversionException> conversionFailures = new ArrayList<ConversionException>();
        this.addToRawHeaders(rawHeaders, convertedHeaders, natives, raws, conversionFailures);
        this.commonHeaders(acknowledgment, consumer, rawHeaders, keys, topics, partitions, offsets, timestampTypes, timestamps);
        boolean logged = false;
        String info = null;
        for (ConsumerRecord<?, ?> record : records) {
            payloads.add(this.obtainPayload(type, record, conversionFailures));
            keys.add(record.key());
            topics.add(record.topic());
            partitions.add(record.partition());
            offsets.add(record.offset());
            if (record.timestampType() != null) {
                timestampTypes.add(record.timestampType().name());
            }
            timestamps.add(record.timestamp());
            if (this.headerMapper != null && record.headers() != null) {
                HashMap<String, Object> converted = new HashMap<String, Object>();
                this.headerMapper.toHeaders(record.headers(), converted);
                convertedHeaders.add(converted);
                Object object = converted.get("kafka_listenerInfo");
                if (object instanceof String) {
                    info = (String)object;
                }
            } else {
                if (!logged) {
                    this.logger.debug(() -> "No header mapper is available; Jackson is required for the default mapper; headers (if present) are not mapped but provided raw in kafka_nativeHeaders");
                    logged = true;
                }
                natives.add(record.headers());
            }
            if (!this.rawRecordHeader) continue;
            raws.add(record);
        }
        if (info != null) {
            rawHeaders.put("kafka_listenerInfo", info);
        }
        return MessageBuilder.createMessage(payloads, (MessageHeaders)kafkaMessageHeaders);
    }

    private void addToRawHeaders(Map<String, Object> rawHeaders, List<Map<String, Object>> convertedHeaders, List<Headers> natives, List<ConsumerRecord<?, ?>> raws, List<ConversionException> conversionFailures) {
        if (this.headerMapper != null) {
            rawHeaders.put("kafka_batchConvertedHeaders", convertedHeaders);
        } else {
            rawHeaders.put("kafka_nativeHeaders", natives);
        }
        if (this.rawRecordHeader) {
            rawHeaders.put("kafka_data", raws);
        }
        rawHeaders.put("kafka_conversionFailures", conversionFailures);
    }

    private Object obtainPayload(Type type, ConsumerRecord<?, ?> record, List<ConversionException> conversionFailures) {
        return this.recordConverter == null || !this.containerType(type) ? this.extractAndConvertValue(record, type) : this.convert(record, type, conversionFailures);
    }

    @Override
    public List<ProducerRecord<?, ?>> fromMessage(Message<?> message, String defaultTopic) {
        throw new UnsupportedOperationException();
    }

    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        return record.value() == null ? KafkaNull.INSTANCE : record.value();
    }

    protected Object convert(ConsumerRecord<?, ?> record, Type type, List<ConversionException> conversionFailures) {
        try {
            Object payload = this.recordConverter.toMessage(record, null, null, ((ParameterizedType)type).getActualTypeArguments()[0]).getPayload();
            conversionFailures.add(null);
            return payload;
        }
        catch (ConversionException ex) {
            byte[] original = null;
            if (record.value() instanceof byte[]) {
                original = (byte[])record.value();
            } else if (record.value() instanceof Bytes) {
                original = ((Bytes)record.value()).get();
            } else if (record.value() instanceof String) {
                original = ((String)record.value()).getBytes(StandardCharsets.UTF_8);
            }
            if (original != null) {
                SerializationUtils.deserializationException(record.headers(), original, (Exception)((Object)ex), false);
                conversionFailures.add(ex);
                return null;
            }
            throw new ConversionException("The batch converter can only report conversion failures to the listener if the record.value() is byte[], Bytes, or String", (Throwable)((Object)ex));
        }
    }

    private boolean containerType(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1;
    }
}

