/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.authserver;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.authserver.AuthorizationServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.KeyStoreKeyFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public class AuthorizationServerTokenServicesConfiguration {

    private static class JwtKeyStoreCondition
    extends SpringBootCondition {
        private JwtKeyStoreCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth JWT KeyStore Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            String keyStore = environment.getProperty("security.oauth2.authorization.jwt.key-store");
            if (StringUtils.hasText((String)keyStore)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided key store location"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("provided key store location").atAll());
        }
    }

    private static class JwtTokenCondition
    extends SpringBootCondition {
        private JwtTokenCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth JWT Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            String keyValue = environment.getProperty("security.oauth2.authorization.jwt.key-value");
            if (StringUtils.hasText((String)keyValue)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided private or symmetric key"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("provided private or symmetric key").atAll());
        }
    }

    @Configuration
    @Conditional(value={JwtKeyStoreCondition.class})
    protected class JwtKeyStoreConfiguration
    implements ApplicationContextAware {
        private final AuthorizationServerProperties authorization;
        private ApplicationContext context;

        @Autowired
        public JwtKeyStoreConfiguration(AuthorizationServerProperties authorization) {
            this.authorization = authorization;
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthorizationServerTokenServices.class})
        public DefaultTokenServices jwtTokenServices(TokenStore jwtTokenStore) {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(jwtTokenStore);
            return services;
        }

        @Bean
        @ConditionalOnMissingBean(value={TokenStore.class})
        public TokenStore tokenStore() {
            return new JwtTokenStore(this.accessTokenConverter());
        }

        @Bean
        public JwtAccessTokenConverter accessTokenConverter() {
            Assert.notNull((Object)this.authorization.getJwt().getKeyStore(), (String)"keyStore cannot be null");
            Assert.notNull((Object)this.authorization.getJwt().getKeyStorePassword(), (String)"keyStorePassword cannot be null");
            Assert.notNull((Object)this.authorization.getJwt().getKeyAlias(), (String)"keyAlias cannot be null");
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            Resource keyStore = this.context.getResource(this.authorization.getJwt().getKeyStore());
            char[] keyStorePassword = this.authorization.getJwt().getKeyStorePassword().toCharArray();
            KeyStoreKeyFactory keyStoreKeyFactory = new KeyStoreKeyFactory(keyStore, keyStorePassword);
            String keyAlias = this.authorization.getJwt().getKeyAlias();
            char[] keyPassword = Optional.ofNullable(this.authorization.getJwt().getKeyPassword()).map(String::toCharArray).orElse(keyStorePassword);
            converter.setKeyPair(keyStoreKeyFactory.getKeyPair(keyAlias, keyPassword));
            return converter;
        }
    }

    @Configuration
    @Conditional(value={JwtTokenCondition.class})
    protected static class JwtTokenServicesConfiguration {
        private final AuthorizationServerProperties authorization;

        public JwtTokenServicesConfiguration(AuthorizationServerProperties authorization) {
            this.authorization = authorization;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthorizationServerTokenServices.class})
        public DefaultTokenServices jwtTokenServices(TokenStore jwtTokenStore) {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(jwtTokenStore);
            return services;
        }

        @Bean
        @ConditionalOnMissingBean(value={TokenStore.class})
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtTokenEnhancer());
        }

        @Bean
        public JwtAccessTokenConverter jwtTokenEnhancer() {
            String keyValue = this.authorization.getJwt().getKeyValue();
            Assert.notNull((Object)this.authorization.getJwt().getKeyValue(), (String)"keyValue cannot be null");
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            if (!keyValue.startsWith("-----BEGIN")) {
                converter.setVerifierKey(keyValue);
            }
            converter.setSigningKey(keyValue);
            return converter;
        }
    }
}

