/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.vote;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class ScopeVoter
implements AccessDecisionVoter<Object> {
    private String scopePrefix = "SCOPE_";
    private String denyAccess = "DENY_OAUTH";
    private boolean throwException = true;

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public void setScopePrefix(String scopePrefix) {
        this.scopePrefix = scopePrefix;
    }

    public void setDenyAccess(String denyAccess) {
        this.denyAccess = denyAccess;
    }

    public boolean supports(ConfigAttribute attribute) {
        return this.denyAccess.equals(attribute.getAttribute()) || attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.scopePrefix);
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        int result = 0;
        if (!(authentication instanceof OAuth2Authentication)) {
            return result;
        }
        for (ConfigAttribute attribute : attributes) {
            if (!this.denyAccess.equals(attribute.getAttribute())) continue;
            return -1;
        }
        OAuth2Request clientAuthentication = ((OAuth2Authentication)authentication).getOAuth2Request();
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            Set scopes = clientAuthentication.getScope();
            for (String scope : scopes) {
                if (!attribute.getAttribute().toUpperCase().equals((String.valueOf(this.scopePrefix) + scope).toUpperCase())) continue;
                return 1;
            }
            if (result != -1 || !this.throwException) continue;
            InsufficientScopeException failure = new InsufficientScopeException("Insufficient scope for this resource", Collections.singleton(attribute.getAttribute().substring(this.scopePrefix.length())));
            throw new AccessDeniedException(failure.getMessage(), (Throwable)failure);
        }
        return result;
    }
}

