/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;

public final class SecurityContextConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SecurityContextConfigurer<H>, H> {
    public SecurityContextConfigurer<H> securityContextRepository(SecurityContextRepository securityContextRepository) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(SecurityContextRepository.class, securityContextRepository);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        SessionCreationPolicy sessionCreationPolicy;
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        if (securityContextRepository == null) {
            securityContextRepository = new HttpSessionSecurityContextRepository();
        }
        SecurityContextPersistenceFilter securityContextFilter = new SecurityContextPersistenceFilter(securityContextRepository);
        SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
        SessionCreationPolicy sessionCreationPolicy2 = sessionCreationPolicy = sessionManagement == null ? null : sessionManagement.getSessionCreationPolicy();
        if (SessionCreationPolicy.ALWAYS == sessionCreationPolicy) {
            securityContextFilter.setForceEagerSessionCreation(true);
        }
        securityContextFilter = this.postProcess(securityContextFilter);
        http.addFilter((Filter)securityContextFilter);
    }
}

