/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc.http.converter;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;

public class OidcUserInfoHttpMessageConverter
extends AbstractHttpMessageConverter<OidcUserInfo> {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    private Converter<Map<String, Object>, OidcUserInfo> userInfoConverter = new MapOidcUserInfoConverter();
    private Converter<OidcUserInfo, Map<String, Object>> userInfoParametersConverter = OidcUserInfo::getClaims;

    public OidcUserInfoHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OidcUserInfo.class.isAssignableFrom(clazz);
    }

    protected OidcUserInfo readInternal(Class<? extends OidcUserInfo> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map userInfoParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            return (OidcUserInfo)this.userInfoConverter.convert((Object)userInfoParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the UserInfo response: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OidcUserInfo oidcUserInfo, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map userInfoResponseParameters = (Map)this.userInfoParametersConverter.convert((Object)oidcUserInfo);
            this.jsonMessageConverter.write((Object)userInfoResponseParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the UserInfo response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setUserInfoConverter(Converter<Map<String, Object>, OidcUserInfo> userInfoConverter) {
        Assert.notNull(userInfoConverter, (String)"userInfoConverter cannot be null");
        this.userInfoConverter = userInfoConverter;
    }

    public final void setUserInfoParametersConverter(Converter<OidcUserInfo, Map<String, Object>> userInfoParametersConverter) {
        Assert.notNull(userInfoParametersConverter, (String)"userInfoParametersConverter cannot be null");
        this.userInfoParametersConverter = userInfoParametersConverter;
    }

    private static final class MapOidcUserInfoConverter
    implements Converter<Map<String, Object>, OidcUserInfo> {
        private static final ClaimConversionService CLAIM_CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
        private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
        private static final TypeDescriptor BOOLEAN_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Boolean.class);
        private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final TypeDescriptor INSTANT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Instant.class);
        private static final TypeDescriptor STRING_OBJECT_MAP_DESCRIPTOR = TypeDescriptor.map(Map.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR, (TypeDescriptor)OBJECT_TYPE_DESCRIPTOR);
        private final ClaimTypeConverter claimTypeConverter;

        private MapOidcUserInfoConverter() {
            Converter<Object, ?> booleanConverter = MapOidcUserInfoConverter.getConverter(BOOLEAN_TYPE_DESCRIPTOR);
            Converter<Object, ?> stringConverter = MapOidcUserInfoConverter.getConverter(STRING_TYPE_DESCRIPTOR);
            Converter<Object, ?> instantConverter = MapOidcUserInfoConverter.getConverter(INSTANT_TYPE_DESCRIPTOR);
            Converter<Object, ?> mapConverter = MapOidcUserInfoConverter.getConverter(STRING_OBJECT_MAP_DESCRIPTOR);
            HashMap claimConverters = new HashMap();
            claimConverters.put("sub", stringConverter);
            claimConverters.put("name", stringConverter);
            claimConverters.put("given_name", stringConverter);
            claimConverters.put("family_name", stringConverter);
            claimConverters.put("middle_name", stringConverter);
            claimConverters.put("nickname", stringConverter);
            claimConverters.put("preferred_username", stringConverter);
            claimConverters.put("profile", stringConverter);
            claimConverters.put("picture", stringConverter);
            claimConverters.put("website", stringConverter);
            claimConverters.put("email", stringConverter);
            claimConverters.put("email_verified", booleanConverter);
            claimConverters.put("gender", stringConverter);
            claimConverters.put("birthdate", stringConverter);
            claimConverters.put("zoneinfo", stringConverter);
            claimConverters.put("locale", stringConverter);
            claimConverters.put("phone_number", stringConverter);
            claimConverters.put("phone_number_verified", booleanConverter);
            claimConverters.put("address", mapConverter);
            claimConverters.put("updated_at", instantConverter);
            this.claimTypeConverter = new ClaimTypeConverter(claimConverters);
        }

        public OidcUserInfo convert(Map<String, Object> source) {
            Map parsedClaims = this.claimTypeConverter.convert(source);
            return new OidcUserInfo(parsedClaims);
        }

        private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
            return source -> CLAIM_CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
        }
    }
}

