/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.util.Assert;

public final class JwtEncodingContext
implements OAuth2TokenContext {
    private final Map<Object, Object> context;

    private JwtEncodingContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public JwsHeader.Builder getHeaders() {
        return this.get(JwsHeader.Builder.class);
    }

    public JwtClaimsSet.Builder getClaims() {
        return this.get(JwtClaimsSet.Builder.class);
    }

    public static Builder with(JwsHeader.Builder headersBuilder, JwtClaimsSet.Builder claimsBuilder) {
        return new Builder(headersBuilder, claimsBuilder);
    }

    public static final class Builder
    extends OAuth2TokenContext.AbstractBuilder<JwtEncodingContext, Builder> {
        private Builder(JwsHeader.Builder headersBuilder, JwtClaimsSet.Builder claimsBuilder) {
            Assert.notNull((Object)headersBuilder, (String)"headersBuilder cannot be null");
            Assert.notNull((Object)claimsBuilder, (String)"claimsBuilder cannot be null");
            this.put(JwsHeader.Builder.class, headersBuilder);
            this.put(JwtClaimsSet.Builder.class, claimsBuilder);
        }

        @Override
        public JwtEncodingContext build() {
            return new JwtEncodingContext(this.getContext());
        }
    }
}

