/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

final class AuthorizationServerContextFilter
extends OncePerRequestFilter {
    private final AuthorizationServerSettings authorizationServerSettings;

    AuthorizationServerContextFilter(AuthorizationServerSettings authorizationServerSettings) {
        Assert.notNull((Object)authorizationServerSettings, (String)"authorizationServerSettings cannot be null");
        this.authorizationServerSettings = authorizationServerSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            DefaultAuthorizationServerContext authorizationServerContext = new DefaultAuthorizationServerContext(() -> AuthorizationServerContextFilter.resolveIssuer(this.authorizationServerSettings, request), this.authorizationServerSettings);
            AuthorizationServerContextHolder.setContext(authorizationServerContext);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            AuthorizationServerContextHolder.resetContext();
        }
    }

    private static String resolveIssuer(AuthorizationServerSettings authorizationServerSettings, HttpServletRequest request) {
        return authorizationServerSettings.getIssuer() != null ? authorizationServerSettings.getIssuer() : AuthorizationServerContextFilter.getContextPath(request);
    }

    private static String getContextPath(HttpServletRequest request) {
        return UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build().toUriString();
    }

    private static final class DefaultAuthorizationServerContext
    implements AuthorizationServerContext {
        private final Supplier<String> issuerSupplier;
        private final AuthorizationServerSettings authorizationServerSettings;

        private DefaultAuthorizationServerContext(Supplier<String> issuerSupplier, AuthorizationServerSettings authorizationServerSettings) {
            this.issuerSupplier = issuerSupplier;
            this.authorizationServerSettings = authorizationServerSettings;
        }

        @Override
        public String getIssuer() {
            return this.issuerSupplier.get();
        }

        @Override
        public AuthorizationServerSettings getAuthorizationServerSettings() {
            return this.authorizationServerSettings;
        }
    }
}

