/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import java.util.function.Consumer;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.oidc.OidcProviderConfiguration;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcProviderConfigurationEndpointFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OidcProviderConfigurationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer;
    private Consumer<OidcProviderConfiguration.Builder> defaultProviderConfigurationCustomizer;

    OidcProviderConfigurationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OidcProviderConfigurationEndpointConfigurer providerConfigurationCustomizer(Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer) {
        this.providerConfigurationCustomizer = providerConfigurationCustomizer;
        return this;
    }

    void addDefaultProviderConfigurationCustomizer(Consumer<OidcProviderConfiguration.Builder> defaultProviderConfigurationCustomizer) {
        this.defaultProviderConfigurationCustomizer = this.defaultProviderConfigurationCustomizer == null ? defaultProviderConfigurationCustomizer : this.defaultProviderConfigurationCustomizer.andThen(defaultProviderConfigurationCustomizer);
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        this.requestMatcher = new AntPathRequestMatcher("/.well-known/openid-configuration", HttpMethod.GET.name());
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        OidcProviderConfigurationEndpointFilter oidcProviderConfigurationEndpointFilter = new OidcProviderConfigurationEndpointFilter();
        Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer = this.getProviderConfigurationCustomizer();
        if (providerConfigurationCustomizer != null) {
            oidcProviderConfigurationEndpointFilter.setProviderConfigurationCustomizer(providerConfigurationCustomizer);
        }
        httpSecurity.addFilterBefore((Filter)this.postProcess(oidcProviderConfigurationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    private Consumer<OidcProviderConfiguration.Builder> getProviderConfigurationCustomizer() {
        Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer = null;
        if (this.defaultProviderConfigurationCustomizer != null || this.providerConfigurationCustomizer != null) {
            if (this.defaultProviderConfigurationCustomizer != null) {
                providerConfigurationCustomizer = this.defaultProviderConfigurationCustomizer;
            }
            if (this.providerConfigurationCustomizer != null) {
                providerConfigurationCustomizer = providerConfigurationCustomizer == null ? this.providerConfigurationCustomizer : providerConfigurationCustomizer.andThen(this.providerConfigurationCustomizer);
            }
        }
        return providerConfigurationCustomizer;
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }
}

