/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationConsentAuthenticationConverter
implements AuthenticationConverter {
    private static final String DEFAULT_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1";
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public Authentication convert(HttpServletRequest request) {
        String state;
        Authentication principal;
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        if (!"POST".equals(request.getMethod()) || parameters.getFirst((Object)"response_type") != null) {
            return null;
        }
        String authorizationUri = request.getRequestURL().toString();
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            OAuth2AuthorizationConsentAuthenticationConverter.throwError("invalid_request", "client_id");
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        if (!StringUtils.hasText((String)(state = (String)parameters.getFirst((Object)"state"))) || ((List)parameters.get((Object)"state")).size() != 1) {
            OAuth2AuthorizationConsentAuthenticationConverter.throwError("invalid_request", "state");
        }
        HashSet<String> scopes = null;
        if (parameters.containsKey((Object)"scope")) {
            scopes = new HashSet<String>((Collection)parameters.get((Object)"scope"));
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("client_id") || key.equals("state") || key.equals("scope"))) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        return new OAuth2AuthorizationConsentAuthenticationToken(authorizationUri, clientId, principal, state, scopes, additionalParameters);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, DEFAULT_ERROR_URI);
        throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, null);
    }
}

