/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

final class AuthorizationServerContextFilter
extends OncePerRequestFilter {
    private final AuthorizationServerSettings authorizationServerSettings;
    private final IssuerResolver issuerResolver;

    AuthorizationServerContextFilter(AuthorizationServerSettings authorizationServerSettings) {
        Assert.notNull((Object)authorizationServerSettings, (String)"authorizationServerSettings cannot be null");
        this.authorizationServerSettings = authorizationServerSettings;
        this.issuerResolver = new IssuerResolver(authorizationServerSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String issuer = this.issuerResolver.resolve(request);
            DefaultAuthorizationServerContext authorizationServerContext = new DefaultAuthorizationServerContext(issuer, this.authorizationServerSettings);
            AuthorizationServerContextHolder.setContext(authorizationServerContext);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            AuthorizationServerContextHolder.resetContext();
        }
    }

    private static final class IssuerResolver {
        private final String issuer;
        private final Set<String> endpointUris;

        private IssuerResolver(AuthorizationServerSettings authorizationServerSettings) {
            if (authorizationServerSettings.getIssuer() != null) {
                this.issuer = authorizationServerSettings.getIssuer();
                this.endpointUris = Collections.emptySet();
            } else {
                this.issuer = null;
                this.endpointUris = new HashSet<String>();
                this.endpointUris.add("/.well-known/oauth-authorization-server");
                this.endpointUris.add("/.well-known/openid-configuration");
                for (Map.Entry<String, Object> setting : authorizationServerSettings.getSettings().entrySet()) {
                    if (!setting.getKey().endsWith("-endpoint")) continue;
                    this.endpointUris.add((String)setting.getValue());
                }
            }
        }

        private String resolve(HttpServletRequest request) {
            if (this.issuer != null) {
                return this.issuer;
            }
            String path = request.getRequestURI();
            if (!StringUtils.hasText((String)path)) {
                path = "";
            } else {
                for (String endpointUri : this.endpointUris) {
                    if (!path.contains(endpointUri)) continue;
                    path = path.replace(endpointUri, "");
                    break;
                }
            }
            return UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(path).replaceQuery(null).fragment(null).build().toUriString();
        }
    }

    private static final class DefaultAuthorizationServerContext
    implements AuthorizationServerContext {
        private final String issuer;
        private final AuthorizationServerSettings authorizationServerSettings;

        private DefaultAuthorizationServerContext(String issuer, AuthorizationServerSettings authorizationServerSettings) {
            this.issuer = issuer;
            this.authorizationServerSettings = authorizationServerSettings;
        }

        @Override
        public String getIssuer() {
            return this.issuer;
        }

        @Override
        public AuthorizationServerSettings getAuthorizationServerSettings() {
            return this.authorizationServerSettings;
        }
    }
}

