/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.lang.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ImportRuntimeHints(value={JdbcOAuth2AuthorizationConsentServiceRuntimeHintsRegistrar.class})
public class JdbcOAuth2AuthorizationConsentService
implements OAuth2AuthorizationConsentService {
    private static final String COLUMN_NAMES = "registered_client_id, principal_name, authorities";
    private static final String TABLE_NAME = "oauth2_authorization_consent";
    private static final String PK_FILTER = "registered_client_id = ? AND principal_name = ?";
    private static final String LOAD_AUTHORIZATION_CONSENT_SQL = "SELECT registered_client_id, principal_name, authorities FROM oauth2_authorization_consent WHERE registered_client_id = ? AND principal_name = ?";
    private static final String SAVE_AUTHORIZATION_CONSENT_SQL = "INSERT INTO oauth2_authorization_consent (registered_client_id, principal_name, authorities) VALUES (?, ?, ?)";
    private static final String UPDATE_AUTHORIZATION_CONSENT_SQL = "UPDATE oauth2_authorization_consent SET authorities = ? WHERE registered_client_id = ? AND principal_name = ?";
    private static final String REMOVE_AUTHORIZATION_CONSENT_SQL = "DELETE FROM oauth2_authorization_consent WHERE registered_client_id = ? AND principal_name = ?";
    private final JdbcOperations jdbcOperations;
    private RowMapper<OAuth2AuthorizationConsent> authorizationConsentRowMapper;
    private Function<OAuth2AuthorizationConsent, List<SqlParameterValue>> authorizationConsentParametersMapper;

    public JdbcOAuth2AuthorizationConsentService(JdbcOperations jdbcOperations, RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        this.jdbcOperations = jdbcOperations;
        this.authorizationConsentRowMapper = new OAuth2AuthorizationConsentRowMapper(registeredClientRepository);
        this.authorizationConsentParametersMapper = new OAuth2AuthorizationConsentParametersMapper();
    }

    @Override
    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        OAuth2AuthorizationConsent existingAuthorizationConsent = this.findById(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
        if (existingAuthorizationConsent == null) {
            this.insertAuthorizationConsent(authorizationConsent);
        } else {
            this.updateAuthorizationConsent(authorizationConsent);
        }
    }

    private void updateAuthorizationConsent(OAuth2AuthorizationConsent authorizationConsent) {
        List<SqlParameterValue> parameters = this.authorizationConsentParametersMapper.apply(authorizationConsent);
        SqlParameterValue registeredClientId = parameters.remove(0);
        SqlParameterValue principalName = parameters.remove(0);
        parameters.add(registeredClientId);
        parameters.add(principalName);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(UPDATE_AUTHORIZATION_CONSENT_SQL, (PreparedStatementSetter)pss);
    }

    private void insertAuthorizationConsent(OAuth2AuthorizationConsent authorizationConsent) {
        List<SqlParameterValue> parameters = this.authorizationConsentParametersMapper.apply(authorizationConsent);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(SAVE_AUTHORIZATION_CONSENT_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)authorizationConsent.getRegisteredClientId()), new SqlParameterValue(12, (Object)authorizationConsent.getPrincipalName())};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(REMOVE_AUTHORIZATION_CONSENT_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    @Nullable
    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        Assert.hasText((String)registeredClientId, (String)"registeredClientId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)registeredClientId), new SqlParameterValue(12, (Object)principalName)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        List result = this.jdbcOperations.query(LOAD_AUTHORIZATION_CONSENT_SQL, (PreparedStatementSetter)pss, this.authorizationConsentRowMapper);
        return !result.isEmpty() ? (OAuth2AuthorizationConsent)result.get(0) : null;
    }

    public final void setAuthorizationConsentRowMapper(RowMapper<OAuth2AuthorizationConsent> authorizationConsentRowMapper) {
        Assert.notNull(authorizationConsentRowMapper, (String)"authorizationConsentRowMapper cannot be null");
        this.authorizationConsentRowMapper = authorizationConsentRowMapper;
    }

    public final void setAuthorizationConsentParametersMapper(Function<OAuth2AuthorizationConsent, List<SqlParameterValue>> authorizationConsentParametersMapper) {
        Assert.notNull(authorizationConsentParametersMapper, (String)"authorizationConsentParametersMapper cannot be null");
        this.authorizationConsentParametersMapper = authorizationConsentParametersMapper;
    }

    protected final JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    protected final RowMapper<OAuth2AuthorizationConsent> getAuthorizationConsentRowMapper() {
        return this.authorizationConsentRowMapper;
    }

    protected final Function<OAuth2AuthorizationConsent, List<SqlParameterValue>> getAuthorizationConsentParametersMapper() {
        return this.authorizationConsentParametersMapper;
    }

    public static class OAuth2AuthorizationConsentRowMapper
    implements RowMapper<OAuth2AuthorizationConsent> {
        private final RegisteredClientRepository registeredClientRepository;

        public OAuth2AuthorizationConsentRowMapper(RegisteredClientRepository registeredClientRepository) {
            Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
            this.registeredClientRepository = registeredClientRepository;
        }

        public OAuth2AuthorizationConsent mapRow(ResultSet rs, int rowNum) throws SQLException {
            String registeredClientId = rs.getString("registered_client_id");
            RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId);
            if (registeredClient == null) {
                throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
            }
            String principalName = rs.getString("principal_name");
            OAuth2AuthorizationConsent.Builder builder = OAuth2AuthorizationConsent.withId(registeredClientId, principalName);
            String authorizationConsentAuthorities = rs.getString("authorities");
            if (authorizationConsentAuthorities != null) {
                for (String authority : StringUtils.commaDelimitedListToSet((String)authorizationConsentAuthorities)) {
                    builder.authority((GrantedAuthority)new SimpleGrantedAuthority(authority));
                }
            }
            return builder.build();
        }

        protected final RegisteredClientRepository getRegisteredClientRepository() {
            return this.registeredClientRepository;
        }
    }

    public static class OAuth2AuthorizationConsentParametersMapper
    implements Function<OAuth2AuthorizationConsent, List<SqlParameterValue>> {
        @Override
        public List<SqlParameterValue> apply(OAuth2AuthorizationConsent authorizationConsent) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)authorizationConsent.getRegisteredClientId()));
            parameters.add(new SqlParameterValue(12, (Object)authorizationConsent.getPrincipalName()));
            HashSet<String> authorities = new HashSet<String>();
            for (GrantedAuthority authority : authorizationConsent.getAuthorities()) {
                authorities.add(authority.getAuthority());
            }
            parameters.add(new SqlParameterValue(12, (Object)StringUtils.collectionToDelimitedString(authorities, (String)",")));
            return parameters;
        }
    }

    static class JdbcOAuth2AuthorizationConsentServiceRuntimeHintsRegistrar
    implements RuntimeHintsRegistrar {
        JdbcOAuth2AuthorizationConsentServiceRuntimeHintsRegistrar() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerResource((Resource)new ClassPathResource("org/springframework/security/oauth2/server/authorization/oauth2-authorization-consent-schema.sql"));
        }
    }
}

