/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.CodeVerifierAuthenticator;
import org.springframework.security.oauth2.server.authorization.authentication.JwtClientAssertionDecoderFactory;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;

public final class JwtClientAssertionAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-3.2.1";
    private static final ClientAuthenticationMethod JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD = new ClientAuthenticationMethod("urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final CodeVerifierAuthenticator codeVerifierAuthenticator;
    private JwtDecoderFactory<RegisteredClient> jwtDecoderFactory;

    public JwtClientAssertionAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.codeVerifierAuthenticator = new CodeVerifierAuthenticator(authorizationService);
        this.jwtDecoderFactory = new JwtClientAssertionDecoderFactory();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ClientAuthenticationMethod clientAuthenticationMethod;
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)authentication;
        if (!JWT_CLIENT_ASSERTION_AUTHENTICATION_METHOD.equals((Object)clientAuthentication.getClientAuthenticationMethod())) {
            return null;
        }
        String clientId = clientAuthentication.getPrincipal().toString();
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        if (registeredClient == null) {
            JwtClientAssertionAuthenticationProvider.throwInvalidClient("client_id");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!registeredClient.getClientAuthenticationMethods().contains(ClientAuthenticationMethod.PRIVATE_KEY_JWT) && !registeredClient.getClientAuthenticationMethods().contains(ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            JwtClientAssertionAuthenticationProvider.throwInvalidClient("authentication_method");
        }
        if (clientAuthentication.getCredentials() == null) {
            JwtClientAssertionAuthenticationProvider.throwInvalidClient("credentials");
        }
        Jwt jwtAssertion = null;
        JwtDecoder jwtDecoder = this.jwtDecoderFactory.createDecoder((Object)registeredClient);
        try {
            jwtAssertion = jwtDecoder.decode(clientAuthentication.getCredentials().toString());
        }
        catch (JwtException ex) {
            JwtClientAssertionAuthenticationProvider.throwInvalidClient("client_assertion", ex);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated client authentication parameters");
        }
        this.codeVerifierAuthenticator.authenticateIfAvailable(clientAuthentication, registeredClient);
        ClientAuthenticationMethod clientAuthenticationMethod2 = clientAuthenticationMethod = registeredClient.getClientSettings().getTokenEndpointAuthenticationSigningAlgorithm() instanceof SignatureAlgorithm ? ClientAuthenticationMethod.PRIVATE_KEY_JWT : ClientAuthenticationMethod.CLIENT_SECRET_JWT;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated client assertion");
        }
        return new OAuth2ClientAuthenticationToken(registeredClient, clientAuthenticationMethod, jwtAssertion);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2ClientAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setJwtDecoderFactory(JwtDecoderFactory<RegisteredClient> jwtDecoderFactory) {
        Assert.notNull(jwtDecoderFactory, (String)"jwtDecoderFactory cannot be null");
        this.jwtDecoderFactory = jwtDecoderFactory;
    }

    private static void throwInvalidClient(String parameterName) {
        JwtClientAssertionAuthenticationProvider.throwInvalidClient(parameterName, null);
    }

    private static void throwInvalidClient(String parameterName, Throwable cause) {
        OAuth2Error error = new OAuth2Error("invalid_client", "Client authentication failed: " + parameterName, ERROR_URI);
        throw new OAuth2AuthenticationException(error, error.toString(), cause);
    }
}

