/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.util.HashSet;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequestUtils;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class OidcReactiveOAuth2UserService
implements ReactiveOAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = new DefaultReactiveOAuth2UserService();

    @Override
    public Mono<OidcUser> loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        return this.getUserInfo(userRequest).map(userInfo -> new OidcUserAuthority(userRequest.getIdToken(), userInfo)).defaultIfEmpty((Object)new OidcUserAuthority(userRequest.getIdToken(), null)).map(authority -> {
            OidcUserInfo userInfo = authority.getUserInfo();
            HashSet<OidcUserAuthority> authorities = new HashSet<OidcUserAuthority>();
            authorities.add((OidcUserAuthority)authority);
            String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
            if (StringUtils.hasText((String)userNameAttributeName)) {
                return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName);
            }
            return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
        });
    }

    private Mono<OidcUserInfo> getUserInfo(OidcUserRequest userRequest) {
        if (!OidcUserRequestUtils.shouldRetrieveUserInfo(userRequest)) {
            return Mono.empty();
        }
        return this.oauth2UserService.loadUser(userRequest).map(OAuth2User::getAttributes).map(OidcUserInfo::new).doOnNext(userInfo -> {
            String subject = userInfo.getSubject();
            if (subject == null || !subject.equals(userRequest.getIdToken().getSubject())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
        });
    }

    public void setOauth2UserService(ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService) {
        Assert.notNull(oauth2UserService, (String)"oauth2UserService cannot be null");
        this.oauth2UserService = oauth2UserService;
    }
}

