/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.method.annotation;

import java.lang.reflect.AnnotatedElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.annotation.RegisteredOAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class OAuth2AuthorizedClientArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient = new DefaultClientCredentialsTokenResponseClient();

    public OAuth2AuthorizedClientArgumentResolver(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        return OAuth2AuthorizedClient.class.isAssignableFrom(parameterType) && AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class) != null;
    }

    @NonNull
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest servletRequest;
        String clientRegistrationId = this.resolveClientRegistrationId(parameter);
        if (StringUtils.isEmpty((Object)clientRegistrationId)) {
            throw new IllegalArgumentException("Unable to resolve the Client Registration Identifier. It must be provided via @RegisteredOAuth2AuthorizedClient(\"client1\") or @RegisteredOAuth2AuthorizedClient(registrationId = \"client1\").");
        }
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        Object authorizedClient = this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        if (authorizedClient != null) {
            return authorizedClient;
        }
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (clientRegistration == null) {
            return null;
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            throw new ClientAuthorizationRequiredException(clientRegistrationId);
        }
        if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            authorizedClient = this.authorizeClientCredentialsClient(clientRegistration, servletRequest, servletResponse);
        }
        return authorizedClient;
    }

    private String resolveClientRegistrationId(MethodParameter parameter) {
        RegisteredOAuth2AuthorizedClient authorizedClientAnnotation = (RegisteredOAuth2AuthorizedClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class);
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        String clientRegistrationId = null;
        if (!StringUtils.isEmpty((Object)authorizedClientAnnotation.registrationId())) {
            clientRegistrationId = authorizedClientAnnotation.registrationId();
        } else if (!StringUtils.isEmpty((Object)authorizedClientAnnotation.value())) {
            clientRegistrationId = authorizedClientAnnotation.value();
        } else if (principal != null && OAuth2AuthenticationToken.class.isAssignableFrom(principal.getClass())) {
            clientRegistrationId = ((OAuth2AuthenticationToken)principal).getAuthorizedClientRegistrationId();
        }
        return clientRegistrationId;
    }

    private OAuth2AuthorizedClient authorizeClientCredentialsClient(ClientRegistration clientRegistration, HttpServletRequest request, HttpServletResponse response) {
        OAuth2ClientCredentialsGrantRequest clientCredentialsGrantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
        OAuth2AccessTokenResponse tokenResponse = this.clientCredentialsTokenResponseClient.getTokenResponse(clientCredentialsGrantRequest);
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(clientRegistration, principal != null ? principal.getName() : "anonymousUser", tokenResponse.getAccessToken());
        this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, request, response);
        return authorizedClient;
    }

    public final void setClientCredentialsTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
    }
}

