/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.Collection;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationCodeAuthenticationTokenConverter;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class OAuth2AuthorizationCodeGrantWebFilter
implements WebFilter {
    private final ReactiveAuthenticationManager authenticationManager;
    private final ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private ServerAuthenticationSuccessHandler authenticationSuccessHandler;
    private ServerAuthenticationConverter authenticationConverter;
    private ServerAuthenticationFailureHandler authenticationFailureHandler;
    private ServerWebExchangeMatcher requiresAuthenticationMatcher;
    private AnonymousAuthenticationToken anonymousToken = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public OAuth2AuthorizationCodeGrantWebFilter(ReactiveAuthenticationManager authenticationManager, ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.authenticationManager = authenticationManager;
        this.authorizedClientRepository = authorizedClientRepository;
        this.requiresAuthenticationMatcher = new PathPatternParserServerWebExchangeMatcher("/{action}/oauth2/code/{registrationId}");
        this.authenticationConverter = new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(clientRegistrationRepository);
        this.authenticationSuccessHandler = new RedirectServerAuthenticationSuccessHandler();
        this.authenticationFailureHandler = (webFilterExchange, exception) -> Mono.error((Throwable)exception);
    }

    public OAuth2AuthorizationCodeGrantWebFilter(ReactiveAuthenticationManager authenticationManager, ServerAuthenticationConverter authenticationConverter, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.authenticationManager = authenticationManager;
        this.authorizedClientRepository = authorizedClientRepository;
        this.requiresAuthenticationMatcher = new PathPatternParserServerWebExchangeMatcher("/{action}/oauth2/code/{registrationId}");
        this.authenticationConverter = authenticationConverter;
        this.authenticationSuccessHandler = new RedirectServerAuthenticationSuccessHandler();
        this.authenticationFailureHandler = (webFilterExchange, exception) -> Mono.error((Throwable)exception);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requiresAuthenticationMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).flatMap(matchResult -> this.authenticationConverter.convert(exchange)).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(token -> this.authenticate(exchange, chain, (Authentication)token));
    }

    private Mono<Void> authenticate(ServerWebExchange exchange, WebFilterChain chain, Authentication token) {
        WebFilterExchange webFilterExchange = new WebFilterExchange(exchange, chain);
        return this.authenticationManager.authenticate(token).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new IllegalStateException("No provider found for " + token.getClass())))).flatMap(authentication -> this.onAuthenticationSuccess((Authentication)authentication, webFilterExchange)).onErrorResume(AuthenticationException.class, e -> this.authenticationFailureHandler.onAuthenticationFailure(webFilterExchange, e));
    }

    private Mono<Void> onAuthenticationSuccess(Authentication authentication, WebFilterExchange webFilterExchange) {
        OAuth2AuthorizationCodeAuthenticationToken authenticationResult = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(authenticationResult.getClientRegistration(), authenticationResult.getName(), authenticationResult.getAccessToken(), authenticationResult.getRefreshToken());
        return this.authenticationSuccessHandler.onAuthenticationSuccess(webFilterExchange, authentication).then(ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)this.anonymousToken).flatMap(principal -> this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, (Authentication)principal, webFilterExchange.getExchange())));
    }
}

