/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public final class WebClientReactiveRefreshTokenTokenResponseClient
implements ReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";
    private WebClient webClient = WebClient.builder().build();

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        Assert.notNull((Object)refreshTokenGrantRequest, (String)"refreshTokenGrantRequest cannot be null");
        return Mono.defer(() -> {
            ClientRegistration clientRegistration = refreshTokenGrantRequest.getClientRegistration();
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(clientRegistration.getProviderDetails().getTokenUri(), new Object[0])).headers(WebClientReactiveRefreshTokenTokenResponseClient.tokenRequestHeaders(clientRegistration))).body(WebClientReactiveRefreshTokenTokenResponseClient.tokenRequestBody(refreshTokenGrantRequest)).exchange().flatMap(response -> {
                HttpStatus status = HttpStatus.resolve((int)response.rawStatusCode());
                if (status == null || !status.is2xxSuccessful()) {
                    OAuth2Error oauth2Error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the OAuth 2.0 Access Token Response: HTTP Status Code " + response.rawStatusCode(), null);
                    return response.bodyToMono(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error)));
                }
                return (Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse());
            }).map(tokenResponse -> WebClientReactiveRefreshTokenTokenResponseClient.tokenResponse(refreshTokenGrantRequest, tokenResponse));
        });
    }

    private static Consumer<HttpHeaders> tokenRequestHeaders(ClientRegistration clientRegistration) {
        return headers -> {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
            }
        };
    }

    private static BodyInserters.FormInserter<String> tokenRequestBody(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        ClientRegistration clientRegistration = refreshTokenGrantRequest.getClientRegistration();
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)refreshTokenGrantRequest.getGrantType().getValue());
        body.with("refresh_token", (Object)refreshTokenGrantRequest.getRefreshToken().getTokenValue());
        if (!CollectionUtils.isEmpty(refreshTokenGrantRequest.getScopes())) {
            body.with("scope", (Object)StringUtils.collectionToDelimitedString(refreshTokenGrantRequest.getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        return body;
    }

    private static OAuth2AccessTokenResponse tokenResponse(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest, OAuth2AccessTokenResponse accessTokenResponse) {
        if (!CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes()) && accessTokenResponse.getRefreshToken() != null) {
            return accessTokenResponse;
        }
        OAuth2AccessTokenResponse.Builder tokenResponseBuilder = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)accessTokenResponse);
        if (CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes())) {
            tokenResponseBuilder.scopes(refreshTokenGrantRequest.getAccessToken().getScopes());
        }
        if (accessTokenResponse.getRefreshToken() == null) {
            tokenResponseBuilder.refreshToken(refreshTokenGrantRequest.getRefreshToken().getTokenValue());
        }
        return tokenResponseBuilder.build();
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }
}

