/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OidcIdTokenValidator
implements OAuth2TokenValidator<Jwt> {
    private static final Duration DEFAULT_CLOCK_SKEW = Duration.ofSeconds(60L);
    private final ClientRegistration clientRegistration;
    private Duration clockSkew = DEFAULT_CLOCK_SKEW;

    public OidcIdTokenValidator(ClientRegistration clientRegistration) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        this.clientRegistration = clientRegistration;
    }

    public OAuth2TokenValidatorResult validate(Jwt idToken) {
        Instant now;
        Map<String, Object> invalidClaims = OidcIdTokenValidator.validateRequiredClaims(idToken);
        if (!invalidClaims.isEmpty()) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{OidcIdTokenValidator.invalidIdToken(invalidClaims)});
        }
        if (!idToken.getAudience().contains(this.clientRegistration.getClientId())) {
            invalidClaims.put("aud", idToken.getAudience());
        }
        String authorizedParty = idToken.getClaimAsString("azp");
        if (idToken.getAudience().size() > 1 && authorizedParty == null) {
            invalidClaims.put("azp", authorizedParty);
        }
        if (authorizedParty != null && !authorizedParty.equals(this.clientRegistration.getClientId())) {
            invalidClaims.put("azp", authorizedParty);
        }
        if ((now = Instant.now()).minus(this.clockSkew).isAfter(idToken.getExpiresAt())) {
            invalidClaims.put("exp", idToken.getExpiresAt());
        }
        if (now.plus(this.clockSkew).isBefore(idToken.getIssuedAt())) {
            invalidClaims.put("iat", idToken.getIssuedAt());
        }
        if (!invalidClaims.isEmpty()) {
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{OidcIdTokenValidator.invalidIdToken(invalidClaims)});
        }
        return OAuth2TokenValidatorResult.success();
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    private static OAuth2Error invalidIdToken(Map<String, Object> invalidClaims) {
        return new OAuth2Error("invalid_id_token", "The ID Token contains invalid claims: " + invalidClaims, "https://openid.net/specs/openid-connect-core-1_0.html#IDTokenValidation");
    }

    private static Map<String, Object> validateRequiredClaims(Jwt idToken) {
        Instant issuedAt;
        Instant expiresAt;
        List audience;
        String subject;
        HashMap<String, Object> requiredClaims = new HashMap<String, Object>();
        URL issuer = idToken.getIssuer();
        if (issuer == null) {
            requiredClaims.put("iss", issuer);
        }
        if ((subject = idToken.getSubject()) == null) {
            requiredClaims.put("sub", subject);
        }
        if (CollectionUtils.isEmpty((Collection)(audience = idToken.getAudience()))) {
            requiredClaims.put("aud", audience);
        }
        if ((expiresAt = idToken.getExpiresAt()) == null) {
            requiredClaims.put("exp", expiresAt);
        }
        if ((issuedAt = idToken.getIssuedAt()) == null) {
            requiredClaims.put("iat", issuedAt);
        }
        return requiredClaims;
    }
}

