/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public final class WebSessionServerOAuth2AuthorizedClientRepository
implements ServerOAuth2AuthorizedClientRepository {
    private static final String DEFAULT_AUTHORIZED_CLIENTS_ATTR_NAME = WebSessionServerOAuth2AuthorizedClientRepository.class.getName() + ".AUTHORIZED_CLIENTS";
    private final String sessionAttributeName = DEFAULT_AUTHORIZED_CLIENTS_ATTR_NAME;

    @Override
    public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange exchange) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return exchange.getSession().map(this::getAuthorizedClients).flatMap(clients -> Mono.justOrEmpty((Object)((OAuth2AuthorizedClient)clients.get(clientRegistrationId))));
    }

    @Override
    public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, ServerWebExchange exchange) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return exchange.getSession().doOnSuccess(session -> {
            Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients((WebSession)session);
            authorizedClients.put(authorizedClient.getClientRegistration().getRegistrationId(), authorizedClient);
            session.getAttributes().put(this.sessionAttributeName, authorizedClients);
        }).then(Mono.empty());
    }

    @Override
    public Mono<Void> removeAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange exchange) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return exchange.getSession().doOnSuccess(session -> {
            Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients((WebSession)session);
            authorizedClients.remove(clientRegistrationId);
            if (authorizedClients.isEmpty()) {
                session.getAttributes().remove(this.sessionAttributeName);
            } else {
                session.getAttributes().put(this.sessionAttributeName, authorizedClients);
            }
        }).then(Mono.empty());
    }

    private Map<String, OAuth2AuthorizedClient> getAuthorizedClients(WebSession session) {
        HashMap authorizedClients;
        HashMap hashMap = authorizedClients = session == null ? null : (HashMap)session.getAttribute(this.sessionAttributeName);
        if (authorizedClients == null) {
            authorizedClients = new HashMap();
        }
        return authorizedClients;
    }
}

