/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.util.Collection;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class OidcUserRequestUtils {
    static boolean shouldRetrieveUserInfo(OidcUserRequest userRequest) {
        ClientRegistration clientRegistration = userRequest.getClientRegistration();
        if (StringUtils.isEmpty((Object)clientRegistration.getProviderDetails().getUserInfoEndpoint().getUri())) {
            return false;
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            return CollectionUtils.containsAny((Collection)userRequest.getAccessToken().getScopes(), userRequest.getClientRegistration().getScopes());
        }
        return false;
    }

    private OidcUserRequestUtils() {
    }
}

